<?php

namespace EnumType;

/**
 * This class stands for FrequencyType EnumType
 * @subpackage Enumerations
 */
class FrequencyType
{
    /**
     * Constant for value 'Weekly'
     * @return string 'Weekly'
     */
    const VALUE_WEEKLY = 'Weekly';
    /**
     * Constant for value 'BiWeekly'
     * @return string 'BiWeekly'
     */
    const VALUE_BI_WEEKLY = 'BiWeekly';
    /**
     * Constant for value 'Monthly'
     * @return string 'Monthly'
     */
    const VALUE_MONTHLY = 'Monthly';
    /**
     * Constant for value 'BiMonthly'
     * @return string 'BiMonthly'
     */
    const VALUE_BI_MONTHLY = 'BiMonthly';
    /**
     * Constant for value 'Quarterly'
     * @return string 'Quarterly'
     */
    const VALUE_QUARTERLY = 'Quarterly';
    /**
     * Constant for value 'SemiYearly'
     * @return string 'SemiYearly'
     */
    const VALUE_SEMI_YEARLY = 'SemiYearly';
    /**
     * Constant for value 'Yearly'
     * @return string 'Yearly'
     */
    const VALUE_YEARLY = 'Yearly';
    /**
     * Constant for value 'EveryFourWeeks'
     * @return string 'EveryFourWeeks'
     */
    const VALUE_EVERY_FOUR_WEEKS = 'EveryFourWeeks';
    /**
     * Constant for value 'EverySixWeeks'
     * @return string 'EverySixWeeks'
     */
    const VALUE_EVERY_SIX_WEEKS = 'EverySixWeeks';
    /**
     * Constant for value 'EveryEightWeeks'
     * @return string 'EveryEightWeeks'
     */
    const VALUE_EVERY_EIGHT_WEEKS = 'EveryEightWeeks';
    /**
     * Constant for value 'EveryTwelveWeeks'
     * @return string 'EveryTwelveWeeks'
     */
    const VALUE_EVERY_TWELVE_WEEKS = 'EveryTwelveWeeks';
    /**
     * Constant for value 'SpecificDays'
     * @return string 'SpecificDays'
     */
    const VALUE_SPECIFIC_DAYS = 'SpecificDays';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WEEKLY
     * @uses self::VALUE_BI_WEEKLY
     * @uses self::VALUE_MONTHLY
     * @uses self::VALUE_BI_MONTHLY
     * @uses self::VALUE_QUARTERLY
     * @uses self::VALUE_SEMI_YEARLY
     * @uses self::VALUE_YEARLY
     * @uses self::VALUE_EVERY_FOUR_WEEKS
     * @uses self::VALUE_EVERY_SIX_WEEKS
     * @uses self::VALUE_EVERY_EIGHT_WEEKS
     * @uses self::VALUE_EVERY_TWELVE_WEEKS
     * @uses self::VALUE_SPECIFIC_DAYS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WEEKLY,
            self::VALUE_BI_WEEKLY,
            self::VALUE_MONTHLY,
            self::VALUE_BI_MONTHLY,
            self::VALUE_QUARTERLY,
            self::VALUE_SEMI_YEARLY,
            self::VALUE_YEARLY,
            self::VALUE_EVERY_FOUR_WEEKS,
            self::VALUE_EVERY_SIX_WEEKS,
            self::VALUE_EVERY_EIGHT_WEEKS,
            self::VALUE_EVERY_TWELVE_WEEKS,
            self::VALUE_SPECIFIC_DAYS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
