<?php

namespace EnumType;

/**
 * This class stands for DepositAccountType EnumType
 * @subpackage Enumerations
 */
class DepositAccountType
{
    /**
     * Constant for value 'Checking'
     * @return string 'Checking'
     */
    const VALUE_CHECKING = 'Checking';
    /**
     * Constant for value 'Saving'
     * @return string 'Saving'
     */
    const VALUE_SAVING = 'Saving';
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'Personal'
     * @return string 'Personal'
     */
    const VALUE_PERSONAL = 'Personal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CHECKING
     * @uses self::VALUE_SAVING
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_PERSONAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CHECKING,
            self::VALUE_SAVING,
            self::VALUE_BUSINESS,
            self::VALUE_PERSONAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
