<?php

namespace EnumType;

/**
 * This class stands for AutoOrderPaymentType EnumType
 * @subpackage Enumerations
 */
class AutoOrderPaymentType
{
    /**
     * Constant for value 'PrimaryCreditCard'
     * @return string 'PrimaryCreditCard'
     */
    const VALUE_PRIMARY_CREDIT_CARD = 'PrimaryCreditCard';
    /**
     * Constant for value 'SecondaryCreditCard'
     * @return string 'SecondaryCreditCard'
     */
    const VALUE_SECONDARY_CREDIT_CARD = 'SecondaryCreditCard';
    /**
     * Constant for value 'CheckingAccount'
     * @return string 'CheckingAccount'
     */
    const VALUE_CHECKING_ACCOUNT = 'CheckingAccount';
    /**
     * Constant for value 'WillSendPayment'
     * @return string 'WillSendPayment'
     */
    const VALUE_WILL_SEND_PAYMENT = 'WillSendPayment';
    /**
     * Constant for value 'BankDraft'
     * @return string 'BankDraft'
     */
    const VALUE_BANK_DRAFT = 'BankDraft';
    /**
     * Constant for value 'PrimaryWalletAccount'
     * @return string 'PrimaryWalletAccount'
     */
    const VALUE_PRIMARY_WALLET_ACCOUNT = 'PrimaryWalletAccount';
    /**
     * Constant for value 'SecondaryWalletAccount'
     * @return string 'SecondaryWalletAccount'
     */
    const VALUE_SECONDARY_WALLET_ACCOUNT = 'SecondaryWalletAccount';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRIMARY_CREDIT_CARD
     * @uses self::VALUE_SECONDARY_CREDIT_CARD
     * @uses self::VALUE_CHECKING_ACCOUNT
     * @uses self::VALUE_WILL_SEND_PAYMENT
     * @uses self::VALUE_BANK_DRAFT
     * @uses self::VALUE_PRIMARY_WALLET_ACCOUNT
     * @uses self::VALUE_SECONDARY_WALLET_ACCOUNT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRIMARY_CREDIT_CARD,
            self::VALUE_SECONDARY_CREDIT_CARD,
            self::VALUE_CHECKING_ACCOUNT,
            self::VALUE_WILL_SEND_PAYMENT,
            self::VALUE_BANK_DRAFT,
            self::VALUE_PRIMARY_WALLET_ACCOUNT,
            self::VALUE_SECONDARY_WALLET_ACCOUNT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
