<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWarehouseResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfWarehouseResponse extends AbstractStructArrayBase
{
    /**
     * The WarehouseResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WarehouseResponse[]
     */
    public $WarehouseResponse;
    /**
     * Constructor method for ArrayOfWarehouseResponse
     * @uses ArrayOfWarehouseResponse::setWarehouseResponse()
     * @param \StructType\WarehouseResponse[] $warehouseResponse
     */
    public function __construct(array $warehouseResponse = array())
    {
        $this
            ->setWarehouseResponse($warehouseResponse);
    }
    /**
     * Get WarehouseResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WarehouseResponse[]|null
     */
    public function getWarehouseResponse()
    {
        return isset($this->WarehouseResponse) ? $this->WarehouseResponse : null;
    }
    /**
     * Set WarehouseResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WarehouseResponse[] $warehouseResponse
     * @return \ArrayType\ArrayOfWarehouseResponse
     */
    public function setWarehouseResponse(array $warehouseResponse = array())
    {
        foreach ($warehouseResponse as $arrayOfWarehouseResponseWarehouseResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfWarehouseResponseWarehouseResponseItem instanceof \StructType\WarehouseResponse) {
                throw new \InvalidArgumentException(sprintf('The WarehouseResponse property can only contain items of \StructType\WarehouseResponse, "%s" given', is_object($arrayOfWarehouseResponseWarehouseResponseItem) ? get_class($arrayOfWarehouseResponseWarehouseResponseItem) : gettype($arrayOfWarehouseResponseWarehouseResponseItem)), __LINE__);
            }
        }
        if (is_null($warehouseResponse) || (is_array($warehouseResponse) && empty($warehouseResponse))) {
            unset($this->WarehouseResponse);
        } else {
            $this->WarehouseResponse = $warehouseResponse;
        }
        return $this;
    }
    /**
     * Add item to WarehouseResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\WarehouseResponse $item
     * @return \ArrayType\ArrayOfWarehouseResponse
     */
    public function addToWarehouseResponse(\StructType\WarehouseResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarehouseResponse) {
            throw new \InvalidArgumentException(sprintf('The WarehouseResponse property can only contain items of \StructType\WarehouseResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WarehouseResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WarehouseResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WarehouseResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WarehouseResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WarehouseResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WarehouseResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WarehouseResponse
     */
    public function getAttributeName()
    {
        return 'WarehouseResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfWarehouseResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
