<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRegionResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfRegionResponse extends AbstractStructArrayBase
{
    /**
     * The RegionResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RegionResponse[]
     */
    public $RegionResponse;
    /**
     * Constructor method for ArrayOfRegionResponse
     * @uses ArrayOfRegionResponse::setRegionResponse()
     * @param \StructType\RegionResponse[] $regionResponse
     */
    public function __construct(array $regionResponse = array())
    {
        $this
            ->setRegionResponse($regionResponse);
    }
    /**
     * Get RegionResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RegionResponse[]|null
     */
    public function getRegionResponse()
    {
        return isset($this->RegionResponse) ? $this->RegionResponse : null;
    }
    /**
     * Set RegionResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RegionResponse[] $regionResponse
     * @return \ArrayType\ArrayOfRegionResponse
     */
    public function setRegionResponse(array $regionResponse = array())
    {
        foreach ($regionResponse as $arrayOfRegionResponseRegionResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfRegionResponseRegionResponseItem instanceof \StructType\RegionResponse) {
                throw new \InvalidArgumentException(sprintf('The RegionResponse property can only contain items of \StructType\RegionResponse, "%s" given', is_object($arrayOfRegionResponseRegionResponseItem) ? get_class($arrayOfRegionResponseRegionResponseItem) : gettype($arrayOfRegionResponseRegionResponseItem)), __LINE__);
            }
        }
        if (is_null($regionResponse) || (is_array($regionResponse) && empty($regionResponse))) {
            unset($this->RegionResponse);
        } else {
            $this->RegionResponse = $regionResponse;
        }
        return $this;
    }
    /**
     * Add item to RegionResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionResponse $item
     * @return \ArrayType\ArrayOfRegionResponse
     */
    public function addToRegionResponse(\StructType\RegionResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegionResponse) {
            throw new \InvalidArgumentException(sprintf('The RegionResponse property can only contain items of \StructType\RegionResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RegionResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RegionResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RegionResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RegionResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RegionResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RegionResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RegionResponse
     */
    public function getAttributeName()
    {
        return 'RegionResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRegionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
