<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProperty ArrayType
 * @subpackage Arrays
 */
class ArrayOfProperty extends AbstractStructArrayBase
{
    /**
     * The Property
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Property[]
     */
    public $Property;
    /**
     * Constructor method for ArrayOfProperty
     * @uses ArrayOfProperty::setProperty()
     * @param \StructType\Property[] $property
     */
    public function __construct(array $property = array())
    {
        $this
            ->setProperty($property);
    }
    /**
     * Get Property value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Property[]|null
     */
    public function getProperty()
    {
        return isset($this->Property) ? $this->Property : null;
    }
    /**
     * Set Property value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Property[] $property
     * @return \ArrayType\ArrayOfProperty
     */
    public function setProperty(array $property = array())
    {
        foreach ($property as $arrayOfPropertyPropertyItem) {
            // validation for constraint: itemType
            if (!$arrayOfPropertyPropertyItem instanceof \StructType\Property) {
                throw new \InvalidArgumentException(sprintf('The Property property can only contain items of \StructType\Property, "%s" given', is_object($arrayOfPropertyPropertyItem) ? get_class($arrayOfPropertyPropertyItem) : gettype($arrayOfPropertyPropertyItem)), __LINE__);
            }
        }
        if (is_null($property) || (is_array($property) && empty($property))) {
            unset($this->Property);
        } else {
            $this->Property = $property;
        }
        return $this;
    }
    /**
     * Add item to Property value
     * @throws \InvalidArgumentException
     * @param \StructType\Property $item
     * @return \ArrayType\ArrayOfProperty
     */
    public function addToProperty(\StructType\Property $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Property) {
            throw new \InvalidArgumentException(sprintf('The Property property can only contain items of \StructType\Property, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Property[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Property|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Property|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Property|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Property|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Property|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Property
     */
    public function getAttributeName()
    {
        return 'Property';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
