<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfPaymentResponse extends AbstractStructArrayBase
{
    /**
     * The PaymentResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentResponse[]
     */
    public $PaymentResponse;
    /**
     * Constructor method for ArrayOfPaymentResponse
     * @uses ArrayOfPaymentResponse::setPaymentResponse()
     * @param \StructType\PaymentResponse[] $paymentResponse
     */
    public function __construct(array $paymentResponse = array())
    {
        $this
            ->setPaymentResponse($paymentResponse);
    }
    /**
     * Get PaymentResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentResponse[]|null
     */
    public function getPaymentResponse()
    {
        return isset($this->PaymentResponse) ? $this->PaymentResponse : null;
    }
    /**
     * Set PaymentResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentResponse[] $paymentResponse
     * @return \ArrayType\ArrayOfPaymentResponse
     */
    public function setPaymentResponse(array $paymentResponse = array())
    {
        foreach ($paymentResponse as $arrayOfPaymentResponsePaymentResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentResponsePaymentResponseItem instanceof \StructType\PaymentResponse) {
                throw new \InvalidArgumentException(sprintf('The PaymentResponse property can only contain items of \StructType\PaymentResponse, "%s" given', is_object($arrayOfPaymentResponsePaymentResponseItem) ? get_class($arrayOfPaymentResponsePaymentResponseItem) : gettype($arrayOfPaymentResponsePaymentResponseItem)), __LINE__);
            }
        }
        if (is_null($paymentResponse) || (is_array($paymentResponse) && empty($paymentResponse))) {
            unset($this->PaymentResponse);
        } else {
            $this->PaymentResponse = $paymentResponse;
        }
        return $this;
    }
    /**
     * Add item to PaymentResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentResponse $item
     * @return \ArrayType\ArrayOfPaymentResponse
     */
    public function addToPaymentResponse(\StructType\PaymentResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentResponse) {
            throw new \InvalidArgumentException(sprintf('The PaymentResponse property can only contain items of \StructType\PaymentResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PaymentResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PaymentResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PaymentResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PaymentResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PaymentResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentResponse
     */
    public function getAttributeName()
    {
        return 'PaymentResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPaymentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
