<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderDetailResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderDetailResponse extends AbstractStructArrayBase
{
    /**
     * The OrderDetailResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderDetailResponse[]
     */
    public $OrderDetailResponse;
    /**
     * Constructor method for ArrayOfOrderDetailResponse
     * @uses ArrayOfOrderDetailResponse::setOrderDetailResponse()
     * @param \StructType\OrderDetailResponse[] $orderDetailResponse
     */
    public function __construct(array $orderDetailResponse = array())
    {
        $this
            ->setOrderDetailResponse($orderDetailResponse);
    }
    /**
     * Get OrderDetailResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderDetailResponse[]|null
     */
    public function getOrderDetailResponse()
    {
        return isset($this->OrderDetailResponse) ? $this->OrderDetailResponse : null;
    }
    /**
     * Set OrderDetailResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderDetailResponse[] $orderDetailResponse
     * @return \ArrayType\ArrayOfOrderDetailResponse
     */
    public function setOrderDetailResponse(array $orderDetailResponse = array())
    {
        foreach ($orderDetailResponse as $arrayOfOrderDetailResponseOrderDetailResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderDetailResponseOrderDetailResponseItem instanceof \StructType\OrderDetailResponse) {
                throw new \InvalidArgumentException(sprintf('The OrderDetailResponse property can only contain items of \StructType\OrderDetailResponse, "%s" given', is_object($arrayOfOrderDetailResponseOrderDetailResponseItem) ? get_class($arrayOfOrderDetailResponseOrderDetailResponseItem) : gettype($arrayOfOrderDetailResponseOrderDetailResponseItem)), __LINE__);
            }
        }
        if (is_null($orderDetailResponse) || (is_array($orderDetailResponse) && empty($orderDetailResponse))) {
            unset($this->OrderDetailResponse);
        } else {
            $this->OrderDetailResponse = $orderDetailResponse;
        }
        return $this;
    }
    /**
     * Add item to OrderDetailResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderDetailResponse $item
     * @return \ArrayType\ArrayOfOrderDetailResponse
     */
    public function addToOrderDetailResponse(\StructType\OrderDetailResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderDetailResponse) {
            throw new \InvalidArgumentException(sprintf('The OrderDetailResponse property can only contain items of \StructType\OrderDetailResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderDetailResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderDetailResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderDetailResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderDetailResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderDetailResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderDetailResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderDetailResponse
     */
    public function getAttributeName()
    {
        return 'OrderDetailResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOrderDetailResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
