<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfKitMemberItemResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfKitMemberItemResponse extends AbstractStructArrayBase
{
    /**
     * The KitMemberItemResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KitMemberItemResponse[]
     */
    public $KitMemberItemResponse;
    /**
     * Constructor method for ArrayOfKitMemberItemResponse
     * @uses ArrayOfKitMemberItemResponse::setKitMemberItemResponse()
     * @param \StructType\KitMemberItemResponse[] $kitMemberItemResponse
     */
    public function __construct(array $kitMemberItemResponse = array())
    {
        $this
            ->setKitMemberItemResponse($kitMemberItemResponse);
    }
    /**
     * Get KitMemberItemResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KitMemberItemResponse[]|null
     */
    public function getKitMemberItemResponse()
    {
        return isset($this->KitMemberItemResponse) ? $this->KitMemberItemResponse : null;
    }
    /**
     * Set KitMemberItemResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KitMemberItemResponse[] $kitMemberItemResponse
     * @return \ArrayType\ArrayOfKitMemberItemResponse
     */
    public function setKitMemberItemResponse(array $kitMemberItemResponse = array())
    {
        foreach ($kitMemberItemResponse as $arrayOfKitMemberItemResponseKitMemberItemResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfKitMemberItemResponseKitMemberItemResponseItem instanceof \StructType\KitMemberItemResponse) {
                throw new \InvalidArgumentException(sprintf('The KitMemberItemResponse property can only contain items of \StructType\KitMemberItemResponse, "%s" given', is_object($arrayOfKitMemberItemResponseKitMemberItemResponseItem) ? get_class($arrayOfKitMemberItemResponseKitMemberItemResponseItem) : gettype($arrayOfKitMemberItemResponseKitMemberItemResponseItem)), __LINE__);
            }
        }
        if (is_null($kitMemberItemResponse) || (is_array($kitMemberItemResponse) && empty($kitMemberItemResponse))) {
            unset($this->KitMemberItemResponse);
        } else {
            $this->KitMemberItemResponse = $kitMemberItemResponse;
        }
        return $this;
    }
    /**
     * Add item to KitMemberItemResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\KitMemberItemResponse $item
     * @return \ArrayType\ArrayOfKitMemberItemResponse
     */
    public function addToKitMemberItemResponse(\StructType\KitMemberItemResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KitMemberItemResponse) {
            throw new \InvalidArgumentException(sprintf('The KitMemberItemResponse property can only contain items of \StructType\KitMemberItemResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->KitMemberItemResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\KitMemberItemResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\KitMemberItemResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\KitMemberItemResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\KitMemberItemResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\KitMemberItemResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string KitMemberItemResponse
     */
    public function getAttributeName()
    {
        return 'KitMemberItemResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfKitMemberItemResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
