<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfItemResponse extends AbstractStructArrayBase
{
    /**
     * The ItemResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemResponse[]
     */
    public $ItemResponse;
    /**
     * Constructor method for ArrayOfItemResponse
     * @uses ArrayOfItemResponse::setItemResponse()
     * @param \StructType\ItemResponse[] $itemResponse
     */
    public function __construct(array $itemResponse = array())
    {
        $this
            ->setItemResponse($itemResponse);
    }
    /**
     * Get ItemResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemResponse[]|null
     */
    public function getItemResponse()
    {
        return isset($this->ItemResponse) ? $this->ItemResponse : null;
    }
    /**
     * Set ItemResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemResponse[] $itemResponse
     * @return \ArrayType\ArrayOfItemResponse
     */
    public function setItemResponse(array $itemResponse = array())
    {
        foreach ($itemResponse as $arrayOfItemResponseItemResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemResponseItemResponseItem instanceof \StructType\ItemResponse) {
                throw new \InvalidArgumentException(sprintf('The ItemResponse property can only contain items of \StructType\ItemResponse, "%s" given', is_object($arrayOfItemResponseItemResponseItem) ? get_class($arrayOfItemResponseItemResponseItem) : gettype($arrayOfItemResponseItemResponseItem)), __LINE__);
            }
        }
        if (is_null($itemResponse) || (is_array($itemResponse) && empty($itemResponse))) {
            unset($this->ItemResponse);
        } else {
            $this->ItemResponse = $itemResponse;
        }
        return $this;
    }
    /**
     * Add item to ItemResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemResponse $item
     * @return \ArrayType\ArrayOfItemResponse
     */
    public function addToItemResponse(\StructType\ItemResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemResponse) {
            throw new \InvalidArgumentException(sprintf('The ItemResponse property can only contain items of \StructType\ItemResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItemResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItemResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItemResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItemResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItemResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemResponse
     */
    public function getAttributeName()
    {
        return 'ItemResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfItemResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
