<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemCountryRegionResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfItemCountryRegionResponse extends AbstractStructArrayBase
{
    /**
     * The ItemCountryRegionResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemCountryRegionResponse[]
     */
    public $ItemCountryRegionResponse;
    /**
     * Constructor method for ArrayOfItemCountryRegionResponse
     * @uses ArrayOfItemCountryRegionResponse::setItemCountryRegionResponse()
     * @param \StructType\ItemCountryRegionResponse[] $itemCountryRegionResponse
     */
    public function __construct(array $itemCountryRegionResponse = array())
    {
        $this
            ->setItemCountryRegionResponse($itemCountryRegionResponse);
    }
    /**
     * Get ItemCountryRegionResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemCountryRegionResponse[]|null
     */
    public function getItemCountryRegionResponse()
    {
        return isset($this->ItemCountryRegionResponse) ? $this->ItemCountryRegionResponse : null;
    }
    /**
     * Set ItemCountryRegionResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemCountryRegionResponse[] $itemCountryRegionResponse
     * @return \ArrayType\ArrayOfItemCountryRegionResponse
     */
    public function setItemCountryRegionResponse(array $itemCountryRegionResponse = array())
    {
        foreach ($itemCountryRegionResponse as $arrayOfItemCountryRegionResponseItemCountryRegionResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemCountryRegionResponseItemCountryRegionResponseItem instanceof \StructType\ItemCountryRegionResponse) {
                throw new \InvalidArgumentException(sprintf('The ItemCountryRegionResponse property can only contain items of \StructType\ItemCountryRegionResponse, "%s" given', is_object($arrayOfItemCountryRegionResponseItemCountryRegionResponseItem) ? get_class($arrayOfItemCountryRegionResponseItemCountryRegionResponseItem) : gettype($arrayOfItemCountryRegionResponseItemCountryRegionResponseItem)), __LINE__);
            }
        }
        if (is_null($itemCountryRegionResponse) || (is_array($itemCountryRegionResponse) && empty($itemCountryRegionResponse))) {
            unset($this->ItemCountryRegionResponse);
        } else {
            $this->ItemCountryRegionResponse = $itemCountryRegionResponse;
        }
        return $this;
    }
    /**
     * Add item to ItemCountryRegionResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemCountryRegionResponse $item
     * @return \ArrayType\ArrayOfItemCountryRegionResponse
     */
    public function addToItemCountryRegionResponse(\StructType\ItemCountryRegionResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemCountryRegionResponse) {
            throw new \InvalidArgumentException(sprintf('The ItemCountryRegionResponse property can only contain items of \StructType\ItemCountryRegionResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemCountryRegionResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItemCountryRegionResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItemCountryRegionResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItemCountryRegionResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItemCountryRegionResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItemCountryRegionResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemCountryRegionResponse
     */
    public function getAttributeName()
    {
        return 'ItemCountryRegionResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfItemCountryRegionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
