<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEmailAttachment ArrayType
 * @subpackage Arrays
 */
class ArrayOfEmailAttachment extends AbstractStructArrayBase
{
    /**
     * The EmailAttachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EmailAttachment[]
     */
    public $EmailAttachment;
    /**
     * Constructor method for ArrayOfEmailAttachment
     * @uses ArrayOfEmailAttachment::setEmailAttachment()
     * @param \StructType\EmailAttachment[] $emailAttachment
     */
    public function __construct(array $emailAttachment = array())
    {
        $this
            ->setEmailAttachment($emailAttachment);
    }
    /**
     * Get EmailAttachment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EmailAttachment[]|null
     */
    public function getEmailAttachment()
    {
        return isset($this->EmailAttachment) ? $this->EmailAttachment : null;
    }
    /**
     * Set EmailAttachment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EmailAttachment[] $emailAttachment
     * @return \ArrayType\ArrayOfEmailAttachment
     */
    public function setEmailAttachment(array $emailAttachment = array())
    {
        foreach ($emailAttachment as $arrayOfEmailAttachmentEmailAttachmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfEmailAttachmentEmailAttachmentItem instanceof \StructType\EmailAttachment) {
                throw new \InvalidArgumentException(sprintf('The EmailAttachment property can only contain items of \StructType\EmailAttachment, "%s" given', is_object($arrayOfEmailAttachmentEmailAttachmentItem) ? get_class($arrayOfEmailAttachmentEmailAttachmentItem) : gettype($arrayOfEmailAttachmentEmailAttachmentItem)), __LINE__);
            }
        }
        if (is_null($emailAttachment) || (is_array($emailAttachment) && empty($emailAttachment))) {
            unset($this->EmailAttachment);
        } else {
            $this->EmailAttachment = $emailAttachment;
        }
        return $this;
    }
    /**
     * Add item to EmailAttachment value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailAttachment $item
     * @return \ArrayType\ArrayOfEmailAttachment
     */
    public function addToEmailAttachment(\StructType\EmailAttachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmailAttachment) {
            throw new \InvalidArgumentException(sprintf('The EmailAttachment property can only contain items of \StructType\EmailAttachment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EmailAttachment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EmailAttachment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EmailAttachment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EmailAttachment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EmailAttachment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EmailAttachment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EmailAttachment
     */
    public function getAttributeName()
    {
        return 'EmailAttachment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEmailAttachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
