<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerSocialNetworkRequest ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerSocialNetworkRequest extends AbstractStructArrayBase
{
    /**
     * The CustomerSocialNetworkRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerSocialNetworkRequest[]
     */
    public $CustomerSocialNetworkRequest;
    /**
     * Constructor method for ArrayOfCustomerSocialNetworkRequest
     * @uses ArrayOfCustomerSocialNetworkRequest::setCustomerSocialNetworkRequest()
     * @param \StructType\CustomerSocialNetworkRequest[] $customerSocialNetworkRequest
     */
    public function __construct(array $customerSocialNetworkRequest = array())
    {
        $this
            ->setCustomerSocialNetworkRequest($customerSocialNetworkRequest);
    }
    /**
     * Get CustomerSocialNetworkRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerSocialNetworkRequest[]|null
     */
    public function getCustomerSocialNetworkRequest()
    {
        return isset($this->CustomerSocialNetworkRequest) ? $this->CustomerSocialNetworkRequest : null;
    }
    /**
     * Set CustomerSocialNetworkRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSocialNetworkRequest[] $customerSocialNetworkRequest
     * @return \ArrayType\ArrayOfCustomerSocialNetworkRequest
     */
    public function setCustomerSocialNetworkRequest(array $customerSocialNetworkRequest = array())
    {
        foreach ($customerSocialNetworkRequest as $arrayOfCustomerSocialNetworkRequestCustomerSocialNetworkRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerSocialNetworkRequestCustomerSocialNetworkRequestItem instanceof \StructType\CustomerSocialNetworkRequest) {
                throw new \InvalidArgumentException(sprintf('The CustomerSocialNetworkRequest property can only contain items of \StructType\CustomerSocialNetworkRequest, "%s" given', is_object($arrayOfCustomerSocialNetworkRequestCustomerSocialNetworkRequestItem) ? get_class($arrayOfCustomerSocialNetworkRequestCustomerSocialNetworkRequestItem) : gettype($arrayOfCustomerSocialNetworkRequestCustomerSocialNetworkRequestItem)), __LINE__);
            }
        }
        if (is_null($customerSocialNetworkRequest) || (is_array($customerSocialNetworkRequest) && empty($customerSocialNetworkRequest))) {
            unset($this->CustomerSocialNetworkRequest);
        } else {
            $this->CustomerSocialNetworkRequest = $customerSocialNetworkRequest;
        }
        return $this;
    }
    /**
     * Add item to CustomerSocialNetworkRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSocialNetworkRequest $item
     * @return \ArrayType\ArrayOfCustomerSocialNetworkRequest
     */
    public function addToCustomerSocialNetworkRequest(\StructType\CustomerSocialNetworkRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSocialNetworkRequest) {
            throw new \InvalidArgumentException(sprintf('The CustomerSocialNetworkRequest property can only contain items of \StructType\CustomerSocialNetworkRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerSocialNetworkRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerSocialNetworkRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerSocialNetworkRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerSocialNetworkRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerSocialNetworkRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerSocialNetworkRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerSocialNetworkRequest
     */
    public function getAttributeName()
    {
        return 'CustomerSocialNetworkRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomerSocialNetworkRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
