<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCommissionResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfCommissionResponse extends AbstractStructArrayBase
{
    /**
     * The CommissionResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CommissionResponse[]
     */
    public $CommissionResponse;
    /**
     * Constructor method for ArrayOfCommissionResponse
     * @uses ArrayOfCommissionResponse::setCommissionResponse()
     * @param \StructType\CommissionResponse[] $commissionResponse
     */
    public function __construct(array $commissionResponse = array())
    {
        $this
            ->setCommissionResponse($commissionResponse);
    }
    /**
     * Get CommissionResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CommissionResponse[]|null
     */
    public function getCommissionResponse()
    {
        return isset($this->CommissionResponse) ? $this->CommissionResponse : null;
    }
    /**
     * Set CommissionResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionResponse[] $commissionResponse
     * @return \ArrayType\ArrayOfCommissionResponse
     */
    public function setCommissionResponse(array $commissionResponse = array())
    {
        foreach ($commissionResponse as $arrayOfCommissionResponseCommissionResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfCommissionResponseCommissionResponseItem instanceof \StructType\CommissionResponse) {
                throw new \InvalidArgumentException(sprintf('The CommissionResponse property can only contain items of \StructType\CommissionResponse, "%s" given', is_object($arrayOfCommissionResponseCommissionResponseItem) ? get_class($arrayOfCommissionResponseCommissionResponseItem) : gettype($arrayOfCommissionResponseCommissionResponseItem)), __LINE__);
            }
        }
        if (is_null($commissionResponse) || (is_array($commissionResponse) && empty($commissionResponse))) {
            unset($this->CommissionResponse);
        } else {
            $this->CommissionResponse = $commissionResponse;
        }
        return $this;
    }
    /**
     * Add item to CommissionResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionResponse $item
     * @return \ArrayType\ArrayOfCommissionResponse
     */
    public function addToCommissionResponse(\StructType\CommissionResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionResponse) {
            throw new \InvalidArgumentException(sprintf('The CommissionResponse property can only contain items of \StructType\CommissionResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CommissionResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CommissionResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CommissionResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CommissionResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CommissionResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CommissionResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CommissionResponse
     */
    public function getAttributeName()
    {
        return 'CommissionResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCommissionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
