<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAutoOrderResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfAutoOrderResponse extends AbstractStructArrayBase
{
    /**
     * The AutoOrderResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AutoOrderResponse[]
     */
    public $AutoOrderResponse;
    /**
     * Constructor method for ArrayOfAutoOrderResponse
     * @uses ArrayOfAutoOrderResponse::setAutoOrderResponse()
     * @param \StructType\AutoOrderResponse[] $autoOrderResponse
     */
    public function __construct(array $autoOrderResponse = array())
    {
        $this
            ->setAutoOrderResponse($autoOrderResponse);
    }
    /**
     * Get AutoOrderResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AutoOrderResponse[]|null
     */
    public function getAutoOrderResponse()
    {
        return isset($this->AutoOrderResponse) ? $this->AutoOrderResponse : null;
    }
    /**
     * Set AutoOrderResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AutoOrderResponse[] $autoOrderResponse
     * @return \ArrayType\ArrayOfAutoOrderResponse
     */
    public function setAutoOrderResponse(array $autoOrderResponse = array())
    {
        foreach ($autoOrderResponse as $arrayOfAutoOrderResponseAutoOrderResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfAutoOrderResponseAutoOrderResponseItem instanceof \StructType\AutoOrderResponse) {
                throw new \InvalidArgumentException(sprintf('The AutoOrderResponse property can only contain items of \StructType\AutoOrderResponse, "%s" given', is_object($arrayOfAutoOrderResponseAutoOrderResponseItem) ? get_class($arrayOfAutoOrderResponseAutoOrderResponseItem) : gettype($arrayOfAutoOrderResponseAutoOrderResponseItem)), __LINE__);
            }
        }
        if (is_null($autoOrderResponse) || (is_array($autoOrderResponse) && empty($autoOrderResponse))) {
            unset($this->AutoOrderResponse);
        } else {
            $this->AutoOrderResponse = $autoOrderResponse;
        }
        return $this;
    }
    /**
     * Add item to AutoOrderResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\AutoOrderResponse $item
     * @return \ArrayType\ArrayOfAutoOrderResponse
     */
    public function addToAutoOrderResponse(\StructType\AutoOrderResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AutoOrderResponse) {
            throw new \InvalidArgumentException(sprintf('The AutoOrderResponse property can only contain items of \StructType\AutoOrderResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AutoOrderResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AutoOrderResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AutoOrderResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AutoOrderResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AutoOrderResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AutoOrderResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AutoOrderResponse
     */
    public function getAttributeName()
    {
        return 'AutoOrderResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAutoOrderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
