<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfApiResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfApiResponse extends AbstractStructArrayBase
{
    /**
     * The ApiResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ApiResponse[]
     */
    public $ApiResponse;
    /**
     * Constructor method for ArrayOfApiResponse
     * @uses ArrayOfApiResponse::setApiResponse()
     * @param \StructType\ApiResponse[] $apiResponse
     */
    public function __construct(array $apiResponse = array())
    {
        $this
            ->setApiResponse($apiResponse);
    }
    /**
     * Get ApiResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ApiResponse[]|null
     */
    public function getApiResponse()
    {
        return isset($this->ApiResponse) ? $this->ApiResponse : null;
    }
    /**
     * Set ApiResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ApiResponse[] $apiResponse
     * @return \ArrayType\ArrayOfApiResponse
     */
    public function setApiResponse(array $apiResponse = array())
    {
        foreach ($apiResponse as $arrayOfApiResponseApiResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfApiResponseApiResponseItem instanceof \StructType\ApiResponse) {
                throw new \InvalidArgumentException(sprintf('The ApiResponse property can only contain items of \StructType\ApiResponse, "%s" given', is_object($arrayOfApiResponseApiResponseItem) ? get_class($arrayOfApiResponseApiResponseItem) : gettype($arrayOfApiResponseApiResponseItem)), __LINE__);
            }
        }
        if (is_null($apiResponse) || (is_array($apiResponse) && empty($apiResponse))) {
            unset($this->ApiResponse);
        } else {
            $this->ApiResponse = $apiResponse;
        }
        return $this;
    }
    /**
     * Add item to ApiResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ApiResponse $item
     * @return \ArrayType\ArrayOfApiResponse
     */
    public function addToApiResponse(\StructType\ApiResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ApiResponse) {
            throw new \InvalidArgumentException(sprintf('The ApiResponse property can only contain items of \StructType\ApiResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ApiResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ApiResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ApiResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ApiResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ApiResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ApiResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ApiResponse
     */
    public function getAttributeName()
    {
        return 'ApiResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfApiResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
