<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveUye
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveUye $parameters
     * @return \StructType\SaveUyeResponse|bool
     */
    public function SaveUye(\StructType\SaveUye $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveUye($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveUyeAdres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveUyeAdres $parameters
     * @return \StructType\SaveUyeAdresResponse|bool
     */
    public function SaveUyeAdres(\StructType\SaveUyeAdres $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveUyeAdres($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveUyeTuru
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveUyeTuru $parameters
     * @return \StructType\SaveUyeTuruResponse|bool
     */
    public function SaveUyeTuru(\StructType\SaveUyeTuru $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveUyeTuru($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SaveUyeAdresResponse|\StructType\SaveUyeResponse|\StructType\SaveUyeTuruResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
