<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.dalida.com.tr/Servis/UyeServis.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.dalida.com.tr/Servis/UyeServis.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Giris ServiceType
 */
$giris = new \ServiceType\Giris($options);
/**
 * Sample call for GirisYap operation/method
 */
if ($giris->GirisYap(new \StructType\GirisYap()) !== false) {
    print_r($giris->getResult());
} else {
    print_r($giris->getLastError());
}
/**
 * Samples for Select ServiceType
 */
$select = new \ServiceType\Select($options);
/**
 * Sample call for SelectUyeler operation/method
 */
if ($select->SelectUyeler(new \StructType\SelectUyeler()) !== false) {
    print_r($select->getResult());
} else {
    print_r($select->getLastError());
}
/**
 * Sample call for SelectUyeAdres operation/method
 */
if ($select->SelectUyeAdres(new \StructType\SelectUyeAdres()) !== false) {
    print_r($select->getResult());
} else {
    print_r($select->getLastError());
}
/**
 * Sample call for SelectUyeTuru operation/method
 */
if ($select->SelectUyeTuru(new \StructType\SelectUyeTuru()) !== false) {
    print_r($select->getResult());
} else {
    print_r($select->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \ServiceType\Save($options);
/**
 * Sample call for SaveUye operation/method
 */
if ($save->SaveUye(new \StructType\SaveUye()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for SaveUyeAdres operation/method
 */
if ($save->SaveUyeAdres(new \StructType\SaveUyeAdres()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for SaveUyeTuru operation/method
 */
if ($save->SaveUyeTuru(new \StructType\SaveUyeTuru()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
