<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UyeSayfalama StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:UyeSayfalama
 * @subpackage Structs
 */
class UyeSayfalama extends AbstractStructBase
{
    /**
     * The KayitSayisi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KayitSayisi;
    /**
     * The SayfaNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SayfaNo;
    /**
     * The SiralamaDegeri
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiralamaDegeri;
    /**
     * The SiralamaYonu
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiralamaYonu;
    /**
     * Constructor method for UyeSayfalama
     * @uses UyeSayfalama::setKayitSayisi()
     * @uses UyeSayfalama::setSayfaNo()
     * @uses UyeSayfalama::setSiralamaDegeri()
     * @uses UyeSayfalama::setSiralamaYonu()
     * @param int $kayitSayisi
     * @param int $sayfaNo
     * @param string $siralamaDegeri
     * @param string $siralamaYonu
     */
    public function __construct($kayitSayisi = null, $sayfaNo = null, $siralamaDegeri = null, $siralamaYonu = null)
    {
        $this
            ->setKayitSayisi($kayitSayisi)
            ->setSayfaNo($sayfaNo)
            ->setSiralamaDegeri($siralamaDegeri)
            ->setSiralamaYonu($siralamaYonu);
    }
    /**
     * Get KayitSayisi value
     * @return int|null
     */
    public function getKayitSayisi()
    {
        return $this->KayitSayisi;
    }
    /**
     * Set KayitSayisi value
     * @param int $kayitSayisi
     * @return \StructType\UyeSayfalama
     */
    public function setKayitSayisi($kayitSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($kayitSayisi) && !is_numeric($kayitSayisi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kayitSayisi)), __LINE__);
        }
        $this->KayitSayisi = $kayitSayisi;
        return $this;
    }
    /**
     * Get SayfaNo value
     * @return int|null
     */
    public function getSayfaNo()
    {
        return $this->SayfaNo;
    }
    /**
     * Set SayfaNo value
     * @param int $sayfaNo
     * @return \StructType\UyeSayfalama
     */
    public function setSayfaNo($sayfaNo = null)
    {
        // validation for constraint: int
        if (!is_null($sayfaNo) && !is_numeric($sayfaNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sayfaNo)), __LINE__);
        }
        $this->SayfaNo = $sayfaNo;
        return $this;
    }
    /**
     * Get SiralamaDegeri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiralamaDegeri()
    {
        return isset($this->SiralamaDegeri) ? $this->SiralamaDegeri : null;
    }
    /**
     * Set SiralamaDegeri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siralamaDegeri
     * @return \StructType\UyeSayfalama
     */
    public function setSiralamaDegeri($siralamaDegeri = null)
    {
        // validation for constraint: string
        if (!is_null($siralamaDegeri) && !is_string($siralamaDegeri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siralamaDegeri)), __LINE__);
        }
        if (is_null($siralamaDegeri) || (is_array($siralamaDegeri) && empty($siralamaDegeri))) {
            unset($this->SiralamaDegeri);
        } else {
            $this->SiralamaDegeri = $siralamaDegeri;
        }
        return $this;
    }
    /**
     * Get SiralamaYonu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiralamaYonu()
    {
        return isset($this->SiralamaYonu) ? $this->SiralamaYonu : null;
    }
    /**
     * Set SiralamaYonu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siralamaYonu
     * @return \StructType\UyeSayfalama
     */
    public function setSiralamaYonu($siralamaYonu = null)
    {
        // validation for constraint: string
        if (!is_null($siralamaYonu) && !is_string($siralamaYonu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siralamaYonu)), __LINE__);
        }
        if (is_null($siralamaYonu) || (is_array($siralamaYonu) && empty($siralamaYonu))) {
            unset($this->SiralamaYonu);
        } else {
            $this->SiralamaYonu = $siralamaYonu;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UyeSayfalama
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
