<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUye ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfUye
 * @subpackage Arrays
 */
class ArrayOfUye extends AbstractStructArrayBase
{
    /**
     * The Uye
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Uye[]
     */
    public $Uye;
    /**
     * Constructor method for ArrayOfUye
     * @uses ArrayOfUye::setUye()
     * @param \StructType\Uye[] $uye
     */
    public function __construct(array $uye = array())
    {
        $this
            ->setUye($uye);
    }
    /**
     * Get Uye value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Uye[]|null
     */
    public function getUye()
    {
        return isset($this->Uye) ? $this->Uye : null;
    }
    /**
     * Set Uye value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Uye[] $uye
     * @return \ArrayType\ArrayOfUye
     */
    public function setUye(array $uye = array())
    {
        foreach ($uye as $arrayOfUyeUyeItem) {
            // validation for constraint: itemType
            if (!$arrayOfUyeUyeItem instanceof \StructType\Uye) {
                throw new \InvalidArgumentException(sprintf('The Uye property can only contain items of \StructType\Uye, "%s" given', is_object($arrayOfUyeUyeItem) ? get_class($arrayOfUyeUyeItem) : gettype($arrayOfUyeUyeItem)), __LINE__);
            }
        }
        if (is_null($uye) || (is_array($uye) && empty($uye))) {
            unset($this->Uye);
        } else {
            $this->Uye = $uye;
        }
        return $this;
    }
    /**
     * Add item to Uye value
     * @throws \InvalidArgumentException
     * @param \StructType\Uye $item
     * @return \ArrayType\ArrayOfUye
     */
    public function addToUye(\StructType\Uye $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Uye) {
            throw new \InvalidArgumentException(sprintf('The Uye property can only contain items of \StructType\Uye, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Uye[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Uye|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Uye|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Uye|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Uye|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Uye|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Uye
     */
    public function getAttributeName()
    {
        return 'Uye';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfUye
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
