<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetKargoSecenek
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKargoSecenek $parameters
     * @return \StructType\GetKargoSecenekResponse|bool
     */
    public function GetKargoSecenek(\StructType\GetKargoSecenek $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetKargoSecenek($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSepet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSepet $parameters
     * @return \StructType\GetSepetResponse|bool
     */
    public function GetSepet(\StructType\GetSepet $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSepet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOdemeTipleri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOdemeTipleri $parameters
     * @return \StructType\GetOdemeTipleriResponse|bool
     */
    public function GetOdemeTipleri(\StructType\GetOdemeTipleri $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOdemeTipleri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetKargoFirmalar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKargoFirmalar $parameters
     * @return \StructType\GetKargoFirmalarResponse|bool
     */
    public function GetKargoFirmalar(\StructType\GetKargoFirmalar $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetKargoFirmalar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetKargoFirmalarResponse|\StructType\GetKargoSecenekResponse|\StructType\GetOdemeTipleriResponse|\StructType\GetSepetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
