<?php

namespace EnumType;

/**
 * This class stands for WebSiparisDurumlari EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WebSiparisDurumlari
 * @subpackage Enumerations
 */
class WebSiparisDurumlari
{
    /**
     * Constant for value 'OnSiparis'
     * @return string 'OnSiparis'
     */
    const VALUE_ON_SIPARIS = 'OnSiparis';
    /**
     * Constant for value 'OnayBekliyor'
     * @return string 'OnayBekliyor'
     */
    const VALUE_ONAY_BEKLIYOR = 'OnayBekliyor';
    /**
     * Constant for value 'Onaylandi'
     * @return string 'Onaylandi'
     */
    const VALUE_ONAYLANDI = 'Onaylandi';
    /**
     * Constant for value 'OdemeBekliyor'
     * @return string 'OdemeBekliyor'
     */
    const VALUE_ODEME_BEKLIYOR = 'OdemeBekliyor';
    /**
     * Constant for value 'Paketleniyor'
     * @return string 'Paketleniyor'
     */
    const VALUE_PAKETLENIYOR = 'Paketleniyor';
    /**
     * Constant for value 'TedarikEdiliyor'
     * @return string 'TedarikEdiliyor'
     */
    const VALUE_TEDARIK_EDILIYOR = 'TedarikEdiliyor';
    /**
     * Constant for value 'KargoyaVerildi'
     * @return string 'KargoyaVerildi'
     */
    const VALUE_KARGOYA_VERILDI = 'KargoyaVerildi';
    /**
     * Constant for value 'TeslimEdildi'
     * @return string 'TeslimEdildi'
     */
    const VALUE_TESLIM_EDILDI = 'TeslimEdildi';
    /**
     * Constant for value 'Iptal'
     * @return string 'Iptal'
     */
    const VALUE_IPTAL = 'Iptal';
    /**
     * Constant for value 'Iade'
     * @return string 'Iade'
     */
    const VALUE_IADE = 'Iade';
    /**
     * Constant for value 'Silinmis'
     * @return string 'Silinmis'
     */
    const VALUE_SILINMIS = 'Silinmis';
    /**
     * Constant for value 'IadeTalepAlindi'
     * @return string 'IadeTalepAlindi'
     */
    const VALUE_IADE_TALEP_ALINDI = 'IadeTalepAlindi';
    /**
     * Constant for value 'IadeUlastiOdemeYapilacak'
     * @return string 'IadeUlastiOdemeYapilacak'
     */
    const VALUE_IADE_ULASTI_ODEME_YAPILACAK = 'IadeUlastiOdemeYapilacak';
    /**
     * Constant for value 'IadeOdemeYapildi'
     * @return string 'IadeOdemeYapildi'
     */
    const VALUE_IADE_ODEME_YAPILDI = 'IadeOdemeYapildi';
    /**
     * Constant for value 'TeslimOncesiIptal'
     * @return string 'TeslimOncesiIptal'
     */
    const VALUE_TESLIM_ONCESI_IPTAL = 'TeslimOncesiIptal';
    /**
     * Constant for value 'IptalTalebi'
     * @return string 'IptalTalebi'
     */
    const VALUE_IPTAL_TALEBI = 'IptalTalebi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ON_SIPARIS
     * @uses self::VALUE_ONAY_BEKLIYOR
     * @uses self::VALUE_ONAYLANDI
     * @uses self::VALUE_ODEME_BEKLIYOR
     * @uses self::VALUE_PAKETLENIYOR
     * @uses self::VALUE_TEDARIK_EDILIYOR
     * @uses self::VALUE_KARGOYA_VERILDI
     * @uses self::VALUE_TESLIM_EDILDI
     * @uses self::VALUE_IPTAL
     * @uses self::VALUE_IADE
     * @uses self::VALUE_SILINMIS
     * @uses self::VALUE_IADE_TALEP_ALINDI
     * @uses self::VALUE_IADE_ULASTI_ODEME_YAPILACAK
     * @uses self::VALUE_IADE_ODEME_YAPILDI
     * @uses self::VALUE_TESLIM_ONCESI_IPTAL
     * @uses self::VALUE_IPTAL_TALEBI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ON_SIPARIS,
            self::VALUE_ONAY_BEKLIYOR,
            self::VALUE_ONAYLANDI,
            self::VALUE_ODEME_BEKLIYOR,
            self::VALUE_PAKETLENIYOR,
            self::VALUE_TEDARIK_EDILIYOR,
            self::VALUE_KARGOYA_VERILDI,
            self::VALUE_TESLIM_EDILDI,
            self::VALUE_IPTAL,
            self::VALUE_IADE,
            self::VALUE_SILINMIS,
            self::VALUE_IADE_TALEP_ALINDI,
            self::VALUE_IADE_ULASTI_ODEME_YAPILACAK,
            self::VALUE_IADE_ODEME_YAPILDI,
            self::VALUE_TESLIM_ONCESI_IPTAL,
            self::VALUE_IPTAL_TALEBI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
