<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebSiparisKargoPaketFiltre StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WebSiparisKargoPaketFiltre
 * @subpackage Structs
 */
class WebSiparisKargoPaketFiltre extends AbstractStructBase
{
    /**
     * The KargoEntegrasyonID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KargoEntegrasyonID;
    /**
     * The KargoTakipNoDurum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KargoTakipNoDurum;
    /**
     * The PaketlenmeTarihBas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaketlenmeTarihBas;
    /**
     * The PaketlenmeTarihBit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaketlenmeTarihBit;
    /**
     * The SiparisID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The SiparisKargoPaketID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisKargoPaketID;
    /**
     * Constructor method for WebSiparisKargoPaketFiltre
     * @uses WebSiparisKargoPaketFiltre::setKargoEntegrasyonID()
     * @uses WebSiparisKargoPaketFiltre::setKargoTakipNoDurum()
     * @uses WebSiparisKargoPaketFiltre::setPaketlenmeTarihBas()
     * @uses WebSiparisKargoPaketFiltre::setPaketlenmeTarihBit()
     * @uses WebSiparisKargoPaketFiltre::setSiparisID()
     * @uses WebSiparisKargoPaketFiltre::setSiparisKargoPaketID()
     * @param int $kargoEntegrasyonID
     * @param int $kargoTakipNoDurum
     * @param string $paketlenmeTarihBas
     * @param string $paketlenmeTarihBit
     * @param int $siparisID
     * @param int $siparisKargoPaketID
     */
    public function __construct($kargoEntegrasyonID = null, $kargoTakipNoDurum = null, $paketlenmeTarihBas = null, $paketlenmeTarihBit = null, $siparisID = null, $siparisKargoPaketID = null)
    {
        $this
            ->setKargoEntegrasyonID($kargoEntegrasyonID)
            ->setKargoTakipNoDurum($kargoTakipNoDurum)
            ->setPaketlenmeTarihBas($paketlenmeTarihBas)
            ->setPaketlenmeTarihBit($paketlenmeTarihBit)
            ->setSiparisID($siparisID)
            ->setSiparisKargoPaketID($siparisKargoPaketID);
    }
    /**
     * Get KargoEntegrasyonID value
     * @return int|null
     */
    public function getKargoEntegrasyonID()
    {
        return $this->KargoEntegrasyonID;
    }
    /**
     * Set KargoEntegrasyonID value
     * @param int $kargoEntegrasyonID
     * @return \StructType\WebSiparisKargoPaketFiltre
     */
    public function setKargoEntegrasyonID($kargoEntegrasyonID = null)
    {
        // validation for constraint: int
        if (!is_null($kargoEntegrasyonID) && !is_numeric($kargoEntegrasyonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kargoEntegrasyonID)), __LINE__);
        }
        $this->KargoEntegrasyonID = $kargoEntegrasyonID;
        return $this;
    }
    /**
     * Get KargoTakipNoDurum value
     * @return int|null
     */
    public function getKargoTakipNoDurum()
    {
        return $this->KargoTakipNoDurum;
    }
    /**
     * Set KargoTakipNoDurum value
     * @param int $kargoTakipNoDurum
     * @return \StructType\WebSiparisKargoPaketFiltre
     */
    public function setKargoTakipNoDurum($kargoTakipNoDurum = null)
    {
        // validation for constraint: int
        if (!is_null($kargoTakipNoDurum) && !is_numeric($kargoTakipNoDurum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kargoTakipNoDurum)), __LINE__);
        }
        $this->KargoTakipNoDurum = $kargoTakipNoDurum;
        return $this;
    }
    /**
     * Get PaketlenmeTarihBas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaketlenmeTarihBas()
    {
        return isset($this->PaketlenmeTarihBas) ? $this->PaketlenmeTarihBas : null;
    }
    /**
     * Set PaketlenmeTarihBas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paketlenmeTarihBas
     * @return \StructType\WebSiparisKargoPaketFiltre
     */
    public function setPaketlenmeTarihBas($paketlenmeTarihBas = null)
    {
        // validation for constraint: string
        if (!is_null($paketlenmeTarihBas) && !is_string($paketlenmeTarihBas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paketlenmeTarihBas)), __LINE__);
        }
        if (is_null($paketlenmeTarihBas) || (is_array($paketlenmeTarihBas) && empty($paketlenmeTarihBas))) {
            unset($this->PaketlenmeTarihBas);
        } else {
            $this->PaketlenmeTarihBas = $paketlenmeTarihBas;
        }
        return $this;
    }
    /**
     * Get PaketlenmeTarihBit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaketlenmeTarihBit()
    {
        return isset($this->PaketlenmeTarihBit) ? $this->PaketlenmeTarihBit : null;
    }
    /**
     * Set PaketlenmeTarihBit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paketlenmeTarihBit
     * @return \StructType\WebSiparisKargoPaketFiltre
     */
    public function setPaketlenmeTarihBit($paketlenmeTarihBit = null)
    {
        // validation for constraint: string
        if (!is_null($paketlenmeTarihBit) && !is_string($paketlenmeTarihBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paketlenmeTarihBit)), __LINE__);
        }
        if (is_null($paketlenmeTarihBit) || (is_array($paketlenmeTarihBit) && empty($paketlenmeTarihBit))) {
            unset($this->PaketlenmeTarihBit);
        } else {
            $this->PaketlenmeTarihBit = $paketlenmeTarihBit;
        }
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \StructType\WebSiparisKargoPaketFiltre
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !is_numeric($siparisID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get SiparisKargoPaketID value
     * @return int|null
     */
    public function getSiparisKargoPaketID()
    {
        return $this->SiparisKargoPaketID;
    }
    /**
     * Set SiparisKargoPaketID value
     * @param int $siparisKargoPaketID
     * @return \StructType\WebSiparisKargoPaketFiltre
     */
    public function setSiparisKargoPaketID($siparisKargoPaketID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisKargoPaketID) && !is_numeric($siparisKargoPaketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($siparisKargoPaketID)), __LINE__);
        }
        $this->SiparisKargoPaketID = $siparisKargoPaketID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebSiparisKargoPaketFiltre
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
