<?php

namespace EnumType;

/**
 * This class stands for BLEnums.UrunDurumlari EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BLEnums.UrunDurumlari
 * @subpackage Enumerations
 */
class BLEnums_UrunDurumlari
{
    /**
     * Constant for value 'Beklemede'
     * @return string 'Beklemede'
     */
    const VALUE_BEKLEMEDE = 'Beklemede';
    /**
     * Constant for value 'Islemde'
     * @return string 'Islemde'
     */
    const VALUE_ISLEMDE = 'Islemde';
    /**
     * Constant for value 'IptalEdildi'
     * @return string 'IptalEdildi'
     */
    const VALUE_IPTAL_EDILDI = 'IptalEdildi';
    /**
     * Constant for value 'KargoyaVerildi'
     * @return string 'KargoyaVerildi'
     */
    const VALUE_KARGOYA_VERILDI = 'KargoyaVerildi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BEKLEMEDE
     * @uses self::VALUE_ISLEMDE
     * @uses self::VALUE_IPTAL_EDILDI
     * @uses self::VALUE_KARGOYA_VERILDI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BEKLEMEDE,
            self::VALUE_ISLEMDE,
            self::VALUE_IPTAL_EDILDI,
            self::VALUE_KARGOYA_VERILDI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
