<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTextValue ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTextValue
 * @subpackage Arrays
 */
class ArrayOfTextValue extends AbstractStructArrayBase
{
    /**
     * The TextValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TextValue[]
     */
    public $TextValue;
    /**
     * Constructor method for ArrayOfTextValue
     * @uses ArrayOfTextValue::setTextValue()
     * @param \StructType\TextValue[] $textValue
     */
    public function __construct(array $textValue = array())
    {
        $this
            ->setTextValue($textValue);
    }
    /**
     * Get TextValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TextValue[]|null
     */
    public function getTextValue()
    {
        return isset($this->TextValue) ? $this->TextValue : null;
    }
    /**
     * Set TextValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TextValue[] $textValue
     * @return \ArrayType\ArrayOfTextValue
     */
    public function setTextValue(array $textValue = array())
    {
        foreach ($textValue as $arrayOfTextValueTextValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfTextValueTextValueItem instanceof \StructType\TextValue) {
                throw new \InvalidArgumentException(sprintf('The TextValue property can only contain items of \StructType\TextValue, "%s" given', is_object($arrayOfTextValueTextValueItem) ? get_class($arrayOfTextValueTextValueItem) : gettype($arrayOfTextValueTextValueItem)), __LINE__);
            }
        }
        if (is_null($textValue) || (is_array($textValue) && empty($textValue))) {
            unset($this->TextValue);
        } else {
            $this->TextValue = $textValue;
        }
        return $this;
    }
    /**
     * Add item to TextValue value
     * @throws \InvalidArgumentException
     * @param \StructType\TextValue $item
     * @return \ArrayType\ArrayOfTextValue
     */
    public function addToTextValue(\StructType\TextValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TextValue) {
            throw new \InvalidArgumentException(sprintf('The TextValue property can only contain items of \StructType\TextValue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TextValue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TextValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TextValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TextValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TextValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TextValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TextValue
     */
    public function getAttributeName()
    {
        return 'TextValue';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTextValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
