<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product StructType
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The category
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $category;
    /**
     * The subcategory
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $subcategory;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $price;
    /**
     * Constructor method for Product
     * @uses Product::setId()
     * @uses Product::setName()
     * @uses Product::setCategory()
     * @uses Product::setSubcategory()
     * @uses Product::setPrice()
     * @param int $id
     * @param string $name
     * @param string $category
     * @param string $subcategory
     * @param float $price
     */
    public function __construct($id = null, $name = null, $category = null, $subcategory = null, $price = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setCategory($category)
            ->setSubcategory($subcategory)
            ->setPrice($price);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Product
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Product
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\Product
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get subcategory value
     * @return string|null
     */
    public function getSubcategory()
    {
        return $this->subcategory;
    }
    /**
     * Set subcategory value
     * @param string $subcategory
     * @return \StructType\Product
     */
    public function setSubcategory($subcategory = null)
    {
        // validation for constraint: string
        if (!is_null($subcategory) && !is_string($subcategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subcategory)), __LINE__);
        }
        $this->subcategory = $subcategory;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\Product
     */
    public function setPrice($price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Product
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
