<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Payment ServiceType
 * @subpackage Services
 */
class Payment extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named payment
     * Meta informations extracted from the WSDL
     * - documentation: Response Mandiri Payment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Payment $parameters
     * @return void|bool
     */
    public function payment(\StructType\Payment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->payment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
