<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Auth ServiceType
 * @subpackage Services
 */
class Auth extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named auth
     * Meta informations extracted from the WSDL
     * - documentation: Authenticates user/password, returning status of true with token, or throws SoapFault.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Auth $parameters
     * @return \StructType\AuthResponse|bool
     */
    public function auth(\StructType\Auth $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->auth($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AuthResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
