<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for payment StructType
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The PaymentResponse
     * @var \StructType\PaymentResponse
     */
    public $PaymentResponse;
    /**
     * The trxDateTime
     * @var string
     */
    public $trxDateTime;
    /**
     * Constructor method for payment
     * @uses Payment::setPaymentResponse()
     * @uses Payment::setTrxDateTime()
     * @param \StructType\PaymentResponse $paymentResponse
     * @param string $trxDateTime
     */
    public function __construct(\StructType\PaymentResponse $paymentResponse = null, $trxDateTime = null)
    {
        $this
            ->setPaymentResponse($paymentResponse)
            ->setTrxDateTime($trxDateTime);
    }
    /**
     * Get PaymentResponse value
     * @return \StructType\PaymentResponse|null
     */
    public function getPaymentResponse()
    {
        return $this->PaymentResponse;
    }
    /**
     * Set PaymentResponse value
     * @param \StructType\PaymentResponse $paymentResponse
     * @return \StructType\Payment
     */
    public function setPaymentResponse(\StructType\PaymentResponse $paymentResponse = null)
    {
        $this->PaymentResponse = $paymentResponse;
        return $this;
    }
    /**
     * Get trxDateTime value
     * @return string|null
     */
    public function getTrxDateTime()
    {
        return $this->trxDateTime;
    }
    /**
     * Set trxDateTime value
     * @param string $trxDateTime
     * @return \StructType\Payment
     */
    public function setTrxDateTime($trxDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($trxDateTime) && !is_string($trxDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trxDateTime)), __LINE__);
        }
        $this->trxDateTime = $trxDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
