<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getProducts StructType
 * @subpackage Structs
 */
class GetProducts extends AbstractStructBase
{
    /**
     * The criteria
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: tns:KeyValue[]
     * - ref: soap-enc:arrayType
     * @var \StructType\KeyValue[]
     */
    public $criteria;
    /**
     * The token
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $token;
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $user;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * Constructor method for getProducts
     * @uses GetProducts::setCriteria()
     * @uses GetProducts::setToken()
     * @uses GetProducts::setUser()
     * @uses GetProducts::setPassword()
     * @param \StructType\KeyValue[] $criteria
     * @param string $token
     * @param string $user
     * @param string $password
     */
    public function __construct(array $criteria = array(), $token = null, $user = null, $password = null)
    {
        $this
            ->setCriteria($criteria)
            ->setToken($token)
            ->setUser($user)
            ->setPassword($password);
    }
    /**
     * Get criteria value
     * @return \StructType\KeyValue[]|null
     */
    public function getCriteria()
    {
        return $this->criteria;
    }
    /**
     * Set criteria value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValue[] $criteria
     * @return \StructType\GetProducts
     */
    public function setCriteria(array $criteria = array())
    {
        foreach ($criteria as $getProductsCriteriaItem) {
            // validation for constraint: itemType
            if (!$getProductsCriteriaItem instanceof \StructType\KeyValue) {
                throw new \InvalidArgumentException(sprintf('The criteria property can only contain items of \StructType\KeyValue, "%s" given', is_object($getProductsCriteriaItem) ? get_class($getProductsCriteriaItem) : gettype($getProductsCriteriaItem)), __LINE__);
            }
        }
        $this->criteria = $criteria;
        return $this;
    }
    /**
     * Add item to criteria value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValue $item
     * @return \StructType\GetProducts
     */
    public function addToCriteria(\StructType\KeyValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValue) {
            throw new \InvalidArgumentException(sprintf('The criteria property can only contain items of \StructType\KeyValue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->criteria[] = $item;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\GetProducts
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\GetProducts
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetProducts
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetProducts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
