<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateAddressResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateAddressResponse
 * @subpackage Structs
 */
class ValidateAddressResponse extends AbstractStructBase
{
    /**
     * The Addresses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAddress
     */
    public $Addresses;
    /**
     * The ValidateAddressResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ValidateAddressResponse
     */
    public $ValidateAddressResult;
    /**
     * Constructor method for ValidateAddressResponse
     * @uses ValidateAddressResponse::setAddresses()
     * @uses ValidateAddressResponse::setValidateAddressResult()
     * @param \ArrayType\ArrayOfAddress $addresses
     * @param \StructType\ValidateAddressResponse $validateAddressResult
     */
    public function __construct(\ArrayType\ArrayOfAddress $addresses = null, \StructType\ValidateAddressResponse $validateAddressResult = null)
    {
        $this
            ->setAddresses($addresses)
            ->setValidateAddressResult($validateAddressResult);
    }
    /**
     * Get Addresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAddress|null
     */
    public function getAddresses()
    {
        return isset($this->Addresses) ? $this->Addresses : null;
    }
    /**
     * Set Addresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAddress $addresses
     * @return \StructType\ValidateAddressResponse
     */
    public function setAddresses(\ArrayType\ArrayOfAddress $addresses = null)
    {
        if (is_null($addresses) || (is_array($addresses) && empty($addresses))) {
            unset($this->Addresses);
        } else {
            $this->Addresses = $addresses;
        }
        return $this;
    }
    /**
     * Get ValidateAddressResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ValidateAddressResponse|null
     */
    public function getValidateAddressResult()
    {
        return isset($this->ValidateAddressResult) ? $this->ValidateAddressResult : null;
    }
    /**
     * Set ValidateAddressResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ValidateAddressResponse $validateAddressResult
     * @return \StructType\ValidateAddressResponse
     */
    public function setValidateAddressResult(\StructType\ValidateAddressResponse $validateAddressResult = null)
    {
        if (is_null($validateAddressResult) || (is_array($validateAddressResult) && empty($validateAddressResult))) {
            unset($this->ValidateAddressResult);
        } else {
            $this->ValidateAddressResult = $validateAddressResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidateAddressResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
