<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateSinglePlanRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RateSinglePlanRequest
 * @subpackage Structs
 */
class RateSinglePlanRequest extends AbstractStructBase
{
    /**
     * The Applicants
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfApplicant
     */
    public $Applicants;
    /**
     * The Credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $Credentials;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The EnrollDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EnrollDate;
    /**
     * The PaymentFrequency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentFrequency;
    /**
     * The PlanToRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SingleRatedPlan
     */
    public $PlanToRate;
    /**
     * The STMTerm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $STMTerm;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The TerminationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TerminationDate;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for RateSinglePlanRequest
     * @uses RateSinglePlanRequest::setApplicants()
     * @uses RateSinglePlanRequest::setCredentials()
     * @uses RateSinglePlanRequest::setEffectiveDate()
     * @uses RateSinglePlanRequest::setEnrollDate()
     * @uses RateSinglePlanRequest::setPaymentFrequency()
     * @uses RateSinglePlanRequest::setPlanToRate()
     * @uses RateSinglePlanRequest::setSTMTerm()
     * @uses RateSinglePlanRequest::setState()
     * @uses RateSinglePlanRequest::setTerminationDate()
     * @uses RateSinglePlanRequest::setZipCode()
     * @param \ArrayType\ArrayOfApplicant $applicants
     * @param \StructType\Credentials $credentials
     * @param string $effectiveDate
     * @param string $enrollDate
     * @param int $paymentFrequency
     * @param \StructType\SingleRatedPlan $planToRate
     * @param int $sTMTerm
     * @param string $state
     * @param string $terminationDate
     * @param string $zipCode
     */
    public function __construct(\ArrayType\ArrayOfApplicant $applicants = null, \StructType\Credentials $credentials = null, $effectiveDate = null, $enrollDate = null, $paymentFrequency = null, \StructType\SingleRatedPlan $planToRate = null, $sTMTerm = null, $state = null, $terminationDate = null, $zipCode = null)
    {
        $this
            ->setApplicants($applicants)
            ->setCredentials($credentials)
            ->setEffectiveDate($effectiveDate)
            ->setEnrollDate($enrollDate)
            ->setPaymentFrequency($paymentFrequency)
            ->setPlanToRate($planToRate)
            ->setSTMTerm($sTMTerm)
            ->setState($state)
            ->setTerminationDate($terminationDate)
            ->setZipCode($zipCode);
    }
    /**
     * Get Applicants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfApplicant|null
     */
    public function getApplicants()
    {
        return isset($this->Applicants) ? $this->Applicants : null;
    }
    /**
     * Set Applicants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfApplicant $applicants
     * @return \StructType\RateSinglePlanRequest
     */
    public function setApplicants(\ArrayType\ArrayOfApplicant $applicants = null)
    {
        if (is_null($applicants) || (is_array($applicants) && empty($applicants))) {
            unset($this->Applicants);
        } else {
            $this->Applicants = $applicants;
        }
        return $this;
    }
    /**
     * Get Credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return isset($this->Credentials) ? $this->Credentials : null;
    }
    /**
     * Set Credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $credentials
     * @return \StructType\RateSinglePlanRequest
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->Credentials);
        } else {
            $this->Credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\RateSinglePlanRequest
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get EnrollDate value
     * @return string|null
     */
    public function getEnrollDate()
    {
        return $this->EnrollDate;
    }
    /**
     * Set EnrollDate value
     * @param string $enrollDate
     * @return \StructType\RateSinglePlanRequest
     */
    public function setEnrollDate($enrollDate = null)
    {
        // validation for constraint: string
        if (!is_null($enrollDate) && !is_string($enrollDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enrollDate)), __LINE__);
        }
        $this->EnrollDate = $enrollDate;
        return $this;
    }
    /**
     * Get PaymentFrequency value
     * @return int|null
     */
    public function getPaymentFrequency()
    {
        return $this->PaymentFrequency;
    }
    /**
     * Set PaymentFrequency value
     * @param int $paymentFrequency
     * @return \StructType\RateSinglePlanRequest
     */
    public function setPaymentFrequency($paymentFrequency = null)
    {
        // validation for constraint: int
        if (!is_null($paymentFrequency) && !is_numeric($paymentFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentFrequency)), __LINE__);
        }
        $this->PaymentFrequency = $paymentFrequency;
        return $this;
    }
    /**
     * Get PlanToRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SingleRatedPlan|null
     */
    public function getPlanToRate()
    {
        return isset($this->PlanToRate) ? $this->PlanToRate : null;
    }
    /**
     * Set PlanToRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SingleRatedPlan $planToRate
     * @return \StructType\RateSinglePlanRequest
     */
    public function setPlanToRate(\StructType\SingleRatedPlan $planToRate = null)
    {
        if (is_null($planToRate) || (is_array($planToRate) && empty($planToRate))) {
            unset($this->PlanToRate);
        } else {
            $this->PlanToRate = $planToRate;
        }
        return $this;
    }
    /**
     * Get STMTerm value
     * @return int|null
     */
    public function getSTMTerm()
    {
        return $this->STMTerm;
    }
    /**
     * Set STMTerm value
     * @param int $sTMTerm
     * @return \StructType\RateSinglePlanRequest
     */
    public function setSTMTerm($sTMTerm = null)
    {
        // validation for constraint: int
        if (!is_null($sTMTerm) && !is_numeric($sTMTerm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sTMTerm)), __LINE__);
        }
        $this->STMTerm = $sTMTerm;
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \StructType\RateSinglePlanRequest
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get TerminationDate value
     * @return string|null
     */
    public function getTerminationDate()
    {
        return $this->TerminationDate;
    }
    /**
     * Set TerminationDate value
     * @param string $terminationDate
     * @return \StructType\RateSinglePlanRequest
     */
    public function setTerminationDate($terminationDate = null)
    {
        // validation for constraint: string
        if (!is_null($terminationDate) && !is_string($terminationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminationDate)), __LINE__);
        }
        $this->TerminationDate = $terminationDate;
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \StructType\RateSinglePlanRequest
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateSinglePlanRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
