<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTermsResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTermsResponse
 * @subpackage Structs
 */
class GetTermsResponse extends AbstractStructBase
{
    /**
     * The AllowableConsecutiveTerms
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AllowableConsecutiveTerms;
    /**
     * The DaysToSubtractMaxTerm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DaysToSubtractMaxTerm;
    /**
     * The DaysToSubtractOtherTerm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DaysToSubtractOtherTerm;
    /**
     * The MaximumMonths
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaximumMonths;
    /**
     * The SinglePaymentMaximumDaysCoverage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SinglePaymentMaximumDaysCoverage;
    /**
     * The SinglePaymentMinimumDaysCoverage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SinglePaymentMinimumDaysCoverage;
    /**
     * The Terms
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTerm
     */
    public $Terms;
    /**
     * The ValidationErrorInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ErrorInformation
     */
    public $ValidationErrorInformation;
    /**
     * Constructor method for GetTermsResponse
     * @uses GetTermsResponse::setAllowableConsecutiveTerms()
     * @uses GetTermsResponse::setDaysToSubtractMaxTerm()
     * @uses GetTermsResponse::setDaysToSubtractOtherTerm()
     * @uses GetTermsResponse::setMaximumMonths()
     * @uses GetTermsResponse::setSinglePaymentMaximumDaysCoverage()
     * @uses GetTermsResponse::setSinglePaymentMinimumDaysCoverage()
     * @uses GetTermsResponse::setTerms()
     * @uses GetTermsResponse::setValidationErrorInformation()
     * @param int $allowableConsecutiveTerms
     * @param int $daysToSubtractMaxTerm
     * @param int $daysToSubtractOtherTerm
     * @param int $maximumMonths
     * @param int $singlePaymentMaximumDaysCoverage
     * @param int $singlePaymentMinimumDaysCoverage
     * @param \ArrayType\ArrayOfTerm $terms
     * @param \StructType\ErrorInformation $validationErrorInformation
     */
    public function __construct($allowableConsecutiveTerms = null, $daysToSubtractMaxTerm = null, $daysToSubtractOtherTerm = null, $maximumMonths = null, $singlePaymentMaximumDaysCoverage = null, $singlePaymentMinimumDaysCoverage = null, \ArrayType\ArrayOfTerm $terms = null, \StructType\ErrorInformation $validationErrorInformation = null)
    {
        $this
            ->setAllowableConsecutiveTerms($allowableConsecutiveTerms)
            ->setDaysToSubtractMaxTerm($daysToSubtractMaxTerm)
            ->setDaysToSubtractOtherTerm($daysToSubtractOtherTerm)
            ->setMaximumMonths($maximumMonths)
            ->setSinglePaymentMaximumDaysCoverage($singlePaymentMaximumDaysCoverage)
            ->setSinglePaymentMinimumDaysCoverage($singlePaymentMinimumDaysCoverage)
            ->setTerms($terms)
            ->setValidationErrorInformation($validationErrorInformation);
    }
    /**
     * Get AllowableConsecutiveTerms value
     * @return int|null
     */
    public function getAllowableConsecutiveTerms()
    {
        return $this->AllowableConsecutiveTerms;
    }
    /**
     * Set AllowableConsecutiveTerms value
     * @param int $allowableConsecutiveTerms
     * @return \StructType\GetTermsResponse
     */
    public function setAllowableConsecutiveTerms($allowableConsecutiveTerms = null)
    {
        // validation for constraint: int
        if (!is_null($allowableConsecutiveTerms) && !is_numeric($allowableConsecutiveTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($allowableConsecutiveTerms)), __LINE__);
        }
        $this->AllowableConsecutiveTerms = $allowableConsecutiveTerms;
        return $this;
    }
    /**
     * Get DaysToSubtractMaxTerm value
     * @return int|null
     */
    public function getDaysToSubtractMaxTerm()
    {
        return $this->DaysToSubtractMaxTerm;
    }
    /**
     * Set DaysToSubtractMaxTerm value
     * @param int $daysToSubtractMaxTerm
     * @return \StructType\GetTermsResponse
     */
    public function setDaysToSubtractMaxTerm($daysToSubtractMaxTerm = null)
    {
        // validation for constraint: int
        if (!is_null($daysToSubtractMaxTerm) && !is_numeric($daysToSubtractMaxTerm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($daysToSubtractMaxTerm)), __LINE__);
        }
        $this->DaysToSubtractMaxTerm = $daysToSubtractMaxTerm;
        return $this;
    }
    /**
     * Get DaysToSubtractOtherTerm value
     * @return int|null
     */
    public function getDaysToSubtractOtherTerm()
    {
        return $this->DaysToSubtractOtherTerm;
    }
    /**
     * Set DaysToSubtractOtherTerm value
     * @param int $daysToSubtractOtherTerm
     * @return \StructType\GetTermsResponse
     */
    public function setDaysToSubtractOtherTerm($daysToSubtractOtherTerm = null)
    {
        // validation for constraint: int
        if (!is_null($daysToSubtractOtherTerm) && !is_numeric($daysToSubtractOtherTerm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($daysToSubtractOtherTerm)), __LINE__);
        }
        $this->DaysToSubtractOtherTerm = $daysToSubtractOtherTerm;
        return $this;
    }
    /**
     * Get MaximumMonths value
     * @return int|null
     */
    public function getMaximumMonths()
    {
        return $this->MaximumMonths;
    }
    /**
     * Set MaximumMonths value
     * @param int $maximumMonths
     * @return \StructType\GetTermsResponse
     */
    public function setMaximumMonths($maximumMonths = null)
    {
        // validation for constraint: int
        if (!is_null($maximumMonths) && !is_numeric($maximumMonths)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumMonths)), __LINE__);
        }
        $this->MaximumMonths = $maximumMonths;
        return $this;
    }
    /**
     * Get SinglePaymentMaximumDaysCoverage value
     * @return int|null
     */
    public function getSinglePaymentMaximumDaysCoverage()
    {
        return $this->SinglePaymentMaximumDaysCoverage;
    }
    /**
     * Set SinglePaymentMaximumDaysCoverage value
     * @param int $singlePaymentMaximumDaysCoverage
     * @return \StructType\GetTermsResponse
     */
    public function setSinglePaymentMaximumDaysCoverage($singlePaymentMaximumDaysCoverage = null)
    {
        // validation for constraint: int
        if (!is_null($singlePaymentMaximumDaysCoverage) && !is_numeric($singlePaymentMaximumDaysCoverage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($singlePaymentMaximumDaysCoverage)), __LINE__);
        }
        $this->SinglePaymentMaximumDaysCoverage = $singlePaymentMaximumDaysCoverage;
        return $this;
    }
    /**
     * Get SinglePaymentMinimumDaysCoverage value
     * @return int|null
     */
    public function getSinglePaymentMinimumDaysCoverage()
    {
        return $this->SinglePaymentMinimumDaysCoverage;
    }
    /**
     * Set SinglePaymentMinimumDaysCoverage value
     * @param int $singlePaymentMinimumDaysCoverage
     * @return \StructType\GetTermsResponse
     */
    public function setSinglePaymentMinimumDaysCoverage($singlePaymentMinimumDaysCoverage = null)
    {
        // validation for constraint: int
        if (!is_null($singlePaymentMinimumDaysCoverage) && !is_numeric($singlePaymentMinimumDaysCoverage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($singlePaymentMinimumDaysCoverage)), __LINE__);
        }
        $this->SinglePaymentMinimumDaysCoverage = $singlePaymentMinimumDaysCoverage;
        return $this;
    }
    /**
     * Get Terms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTerm|null
     */
    public function getTerms()
    {
        return isset($this->Terms) ? $this->Terms : null;
    }
    /**
     * Set Terms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTerm $terms
     * @return \StructType\GetTermsResponse
     */
    public function setTerms(\ArrayType\ArrayOfTerm $terms = null)
    {
        if (is_null($terms) || (is_array($terms) && empty($terms))) {
            unset($this->Terms);
        } else {
            $this->Terms = $terms;
        }
        return $this;
    }
    /**
     * Get ValidationErrorInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ErrorInformation|null
     */
    public function getValidationErrorInformation()
    {
        return isset($this->ValidationErrorInformation) ? $this->ValidationErrorInformation : null;
    }
    /**
     * Set ValidationErrorInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ErrorInformation $validationErrorInformation
     * @return \StructType\GetTermsResponse
     */
    public function setValidationErrorInformation(\StructType\ErrorInformation $validationErrorInformation = null)
    {
        if (is_null($validationErrorInformation) || (is_array($validationErrorInformation) && empty($validationErrorInformation))) {
            unset($this->ValidationErrorInformation);
        } else {
            $this->ValidationErrorInformation = $validationErrorInformation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetTermsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
