<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalCoverage StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AdditionalCoverage
 * @subpackage Structs
 */
class AdditionalCoverage extends AbstractStructBase
{
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The InsuranceRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $InsuranceRate;
    /**
     * The MemberRates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMemberRate
     */
    public $MemberRates;
    /**
     * The MonthlyPaymentTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MonthlyPaymentTotal;
    /**
     * The TotalRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalRate;
    /**
     * Constructor method for AdditionalCoverage
     * @uses AdditionalCoverage::setEffectiveDate()
     * @uses AdditionalCoverage::setInsuranceRate()
     * @uses AdditionalCoverage::setMemberRates()
     * @uses AdditionalCoverage::setMonthlyPaymentTotal()
     * @uses AdditionalCoverage::setTotalRate()
     * @param string $effectiveDate
     * @param float $insuranceRate
     * @param \ArrayType\ArrayOfMemberRate $memberRates
     * @param float $monthlyPaymentTotal
     * @param float $totalRate
     */
    public function __construct($effectiveDate = null, $insuranceRate = null, \ArrayType\ArrayOfMemberRate $memberRates = null, $monthlyPaymentTotal = null, $totalRate = null)
    {
        $this
            ->setEffectiveDate($effectiveDate)
            ->setInsuranceRate($insuranceRate)
            ->setMemberRates($memberRates)
            ->setMonthlyPaymentTotal($monthlyPaymentTotal)
            ->setTotalRate($totalRate);
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\AdditionalCoverage
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get InsuranceRate value
     * @return float|null
     */
    public function getInsuranceRate()
    {
        return $this->InsuranceRate;
    }
    /**
     * Set InsuranceRate value
     * @param float $insuranceRate
     * @return \StructType\AdditionalCoverage
     */
    public function setInsuranceRate($insuranceRate = null)
    {
        $this->InsuranceRate = $insuranceRate;
        return $this;
    }
    /**
     * Get MemberRates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMemberRate|null
     */
    public function getMemberRates()
    {
        return isset($this->MemberRates) ? $this->MemberRates : null;
    }
    /**
     * Set MemberRates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMemberRate $memberRates
     * @return \StructType\AdditionalCoverage
     */
    public function setMemberRates(\ArrayType\ArrayOfMemberRate $memberRates = null)
    {
        if (is_null($memberRates) || (is_array($memberRates) && empty($memberRates))) {
            unset($this->MemberRates);
        } else {
            $this->MemberRates = $memberRates;
        }
        return $this;
    }
    /**
     * Get MonthlyPaymentTotal value
     * @return float|null
     */
    public function getMonthlyPaymentTotal()
    {
        return $this->MonthlyPaymentTotal;
    }
    /**
     * Set MonthlyPaymentTotal value
     * @param float $monthlyPaymentTotal
     * @return \StructType\AdditionalCoverage
     */
    public function setMonthlyPaymentTotal($monthlyPaymentTotal = null)
    {
        $this->MonthlyPaymentTotal = $monthlyPaymentTotal;
        return $this;
    }
    /**
     * Get TotalRate value
     * @return float|null
     */
    public function getTotalRate()
    {
        return $this->TotalRate;
    }
    /**
     * Set TotalRate value
     * @param float $totalRate
     * @return \StructType\AdditionalCoverage
     */
    public function setTotalRate($totalRate = null)
    {
        $this->TotalRate = $totalRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalCoverage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
