<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rate ServiceType
 * @subpackage Services
 */
class Rate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RatePlans
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RatePlans $parameters
     * @return \StructType\RatePlansResponse|bool
     */
    public function RatePlans(\StructType\RatePlans $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RatePlans($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RateCart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RateCart $parameters
     * @return \StructType\RateCartResponse|bool
     */
    public function RateCart(\StructType\RateCart $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RateCart($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RateSinglePlan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RateSinglePlan $parameters
     * @return \StructType\RateSinglePlanResponse|bool
     */
    public function RateSinglePlan(\StructType\RateSinglePlan $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RateSinglePlan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RateCartResponse|\StructType\RatePlansResponse|\StructType\RateSinglePlanResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
