<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetValidEffectiveDates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetValidEffectiveDates $parameters
     * @return \StructType\GetValidEffectiveDatesResponse|bool
     */
    public function GetValidEffectiveDates(\StructType\GetValidEffectiveDates $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetValidEffectiveDates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEffectiveDateRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEffectiveDateRange $parameters
     * @return \StructType\GetEffectiveDateRangeResponse|bool
     */
    public function GetEffectiveDateRange(\StructType\GetEffectiveDateRange $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEffectiveDateRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetState $parameters
     * @return \StructType\GetStateResponse|bool
     */
    public function GetState(\StructType\GetState $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetState($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAgentInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAgentInformation $parameters
     * @return \StructType\GetAgentInformationResponse|bool
     */
    public function GetAgentInformation(\StructType\GetAgentInformation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAgentInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListBill
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListBill $parameters
     * @return \StructType\GetListBillResponse|bool
     */
    public function GetListBill(\StructType\GetListBill $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetListBill($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSTMTerms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSTMTerms $parameters
     * @return \StructType\GetSTMTermsResponse|bool
     */
    public function GetSTMTerms(\StructType\GetSTMTerms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSTMTerms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAgentInformationResponse|\StructType\GetEffectiveDateRangeResponse|\StructType\GetListBillResponse|\StructType\GetStateResponse|\StructType\GetSTMTermsResponse|\StructType\GetValidEffectiveDatesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
