<?php

namespace EnumType;

/**
 * This class stands for ProductTypeId EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductTypeId
 * @subpackage Enumerations
 */
class ProductTypeId
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'STM'
     * @return string 'STM'
     */
    const VALUE_STM = 'STM';
    /**
     * Constant for value 'NHICSupplemental'
     * @return string 'NHICSupplemental'
     */
    const VALUE_NHICSUPPLEMENTAL = 'NHICSupplemental';
    /**
     * Constant for value 'TIC'
     * @return string 'TIC'
     */
    const VALUE_TIC = 'TIC';
    /**
     * Constant for value 'StarmountDental'
     * @return string 'StarmountDental'
     */
    const VALUE_STARMOUNT_DENTAL = 'StarmountDental';
    /**
     * Constant for value 'Association'
     * @return string 'Association'
     */
    const VALUE_ASSOCIATION = 'Association';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_STM
     * @uses self::VALUE_NHICSUPPLEMENTAL
     * @uses self::VALUE_TIC
     * @uses self::VALUE_STARMOUNT_DENTAL
     * @uses self::VALUE_ASSOCIATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_STM,
            self::VALUE_NHICSUPPLEMENTAL,
            self::VALUE_TIC,
            self::VALUE_STARMOUNT_DENTAL,
            self::VALUE_ASSOCIATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
