<?php

namespace EnumType;

/**
 * This class stands for AddressValidation EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddressValidation
 * @subpackage Enumerations
 */
class AddressValidation
{
    /**
     * Constant for value 'Unchanged'
     * @return string 'Unchanged'
     */
    const VALUE_UNCHANGED = 'Unchanged';
    /**
     * Constant for value 'PrimarySuggested'
     * @return string 'PrimarySuggested'
     */
    const VALUE_PRIMARY_SUGGESTED = 'PrimarySuggested';
    /**
     * Constant for value 'AlternateSuggested'
     * @return string 'AlternateSuggested'
     */
    const VALUE_ALTERNATE_SUGGESTED = 'AlternateSuggested';
    /**
     * Constant for value 'Original'
     * @return string 'Original'
     */
    const VALUE_ORIGINAL = 'Original';
    /**
     * Constant for value 'NotFound'
     * @return string 'NotFound'
     */
    const VALUE_NOT_FOUND = 'NotFound';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNCHANGED
     * @uses self::VALUE_PRIMARY_SUGGESTED
     * @uses self::VALUE_ALTERNATE_SUGGESTED
     * @uses self::VALUE_ORIGINAL
     * @uses self::VALUE_NOT_FOUND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNCHANGED,
            self::VALUE_PRIMARY_SUGGESTED,
            self::VALUE_ALTERNATE_SUGGESTED,
            self::VALUE_ORIGINAL,
            self::VALUE_NOT_FOUND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
