<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRider ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRider
 * @subpackage Arrays
 */
class ArrayOfRider extends AbstractStructArrayBase
{
    /**
     * The Rider
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Rider[]
     */
    public $Rider;
    /**
     * Constructor method for ArrayOfRider
     * @uses ArrayOfRider::setRider()
     * @param \StructType\Rider[] $rider
     */
    public function __construct(array $rider = array())
    {
        $this
            ->setRider($rider);
    }
    /**
     * Get Rider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Rider[]|null
     */
    public function getRider()
    {
        return isset($this->Rider) ? $this->Rider : null;
    }
    /**
     * Set Rider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Rider[] $rider
     * @return \ArrayType\ArrayOfRider
     */
    public function setRider(array $rider = array())
    {
        foreach ($rider as $arrayOfRiderRiderItem) {
            // validation for constraint: itemType
            if (!$arrayOfRiderRiderItem instanceof \StructType\Rider) {
                throw new \InvalidArgumentException(sprintf('The Rider property can only contain items of \StructType\Rider, "%s" given', is_object($arrayOfRiderRiderItem) ? get_class($arrayOfRiderRiderItem) : gettype($arrayOfRiderRiderItem)), __LINE__);
            }
        }
        if (is_null($rider) || (is_array($rider) && empty($rider))) {
            unset($this->Rider);
        } else {
            $this->Rider = $rider;
        }
        return $this;
    }
    /**
     * Add item to Rider value
     * @throws \InvalidArgumentException
     * @param \StructType\Rider $item
     * @return \ArrayType\ArrayOfRider
     */
    public function addToRider(\StructType\Rider $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Rider) {
            throw new \InvalidArgumentException(sprintf('The Rider property can only contain items of \StructType\Rider, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Rider[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Rider|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Rider|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Rider|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Rider|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Rider|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Rider
     */
    public function getAttributeName()
    {
        return 'Rider';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRider
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
