<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRatedPlan ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRatedPlan
 * @subpackage Arrays
 */
class ArrayOfRatedPlan extends AbstractStructArrayBase
{
    /**
     * The RatedPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RatedPlan[]
     */
    public $RatedPlan;
    /**
     * Constructor method for ArrayOfRatedPlan
     * @uses ArrayOfRatedPlan::setRatedPlan()
     * @param \StructType\RatedPlan[] $ratedPlan
     */
    public function __construct(array $ratedPlan = array())
    {
        $this
            ->setRatedPlan($ratedPlan);
    }
    /**
     * Get RatedPlan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RatedPlan[]|null
     */
    public function getRatedPlan()
    {
        return isset($this->RatedPlan) ? $this->RatedPlan : null;
    }
    /**
     * Set RatedPlan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RatedPlan[] $ratedPlan
     * @return \ArrayType\ArrayOfRatedPlan
     */
    public function setRatedPlan(array $ratedPlan = array())
    {
        foreach ($ratedPlan as $arrayOfRatedPlanRatedPlanItem) {
            // validation for constraint: itemType
            if (!$arrayOfRatedPlanRatedPlanItem instanceof \StructType\RatedPlan) {
                throw new \InvalidArgumentException(sprintf('The RatedPlan property can only contain items of \StructType\RatedPlan, "%s" given', is_object($arrayOfRatedPlanRatedPlanItem) ? get_class($arrayOfRatedPlanRatedPlanItem) : gettype($arrayOfRatedPlanRatedPlanItem)), __LINE__);
            }
        }
        if (is_null($ratedPlan) || (is_array($ratedPlan) && empty($ratedPlan))) {
            unset($this->RatedPlan);
        } else {
            $this->RatedPlan = $ratedPlan;
        }
        return $this;
    }
    /**
     * Add item to RatedPlan value
     * @throws \InvalidArgumentException
     * @param \StructType\RatedPlan $item
     * @return \ArrayType\ArrayOfRatedPlan
     */
    public function addToRatedPlan(\StructType\RatedPlan $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RatedPlan) {
            throw new \InvalidArgumentException(sprintf('The RatedPlan property can only contain items of \StructType\RatedPlan, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RatedPlan[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RatedPlan|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RatedPlan|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RatedPlan|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RatedPlan|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RatedPlan|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RatedPlan
     */
    public function getAttributeName()
    {
        return 'RatedPlan';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRatedPlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
