<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMemberRate ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMemberRate
 * @subpackage Arrays
 */
class ArrayOfMemberRate extends AbstractStructArrayBase
{
    /**
     * The MemberRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MemberRate[]
     */
    public $MemberRate;
    /**
     * Constructor method for ArrayOfMemberRate
     * @uses ArrayOfMemberRate::setMemberRate()
     * @param \StructType\MemberRate[] $memberRate
     */
    public function __construct(array $memberRate = array())
    {
        $this
            ->setMemberRate($memberRate);
    }
    /**
     * Get MemberRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MemberRate[]|null
     */
    public function getMemberRate()
    {
        return isset($this->MemberRate) ? $this->MemberRate : null;
    }
    /**
     * Set MemberRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MemberRate[] $memberRate
     * @return \ArrayType\ArrayOfMemberRate
     */
    public function setMemberRate(array $memberRate = array())
    {
        foreach ($memberRate as $arrayOfMemberRateMemberRateItem) {
            // validation for constraint: itemType
            if (!$arrayOfMemberRateMemberRateItem instanceof \StructType\MemberRate) {
                throw new \InvalidArgumentException(sprintf('The MemberRate property can only contain items of \StructType\MemberRate, "%s" given', is_object($arrayOfMemberRateMemberRateItem) ? get_class($arrayOfMemberRateMemberRateItem) : gettype($arrayOfMemberRateMemberRateItem)), __LINE__);
            }
        }
        if (is_null($memberRate) || (is_array($memberRate) && empty($memberRate))) {
            unset($this->MemberRate);
        } else {
            $this->MemberRate = $memberRate;
        }
        return $this;
    }
    /**
     * Add item to MemberRate value
     * @throws \InvalidArgumentException
     * @param \StructType\MemberRate $item
     * @return \ArrayType\ArrayOfMemberRate
     */
    public function addToMemberRate(\StructType\MemberRate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MemberRate) {
            throw new \InvalidArgumentException(sprintf('The MemberRate property can only contain items of \StructType\MemberRate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MemberRate[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MemberRate|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MemberRate|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MemberRate|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MemberRate|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MemberRate|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MemberRate
     */
    public function getAttributeName()
    {
        return 'MemberRate';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMemberRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
