<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://qa1-ngahservices.ngic.com/QuotingBroker/QuotingBroker.svc?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://qa1-ngahservices.ngic.com/QuotingBroker/QuotingBroker.svc?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetValidEffectiveDates operation/method
 */
if ($get->GetValidEffectiveDates(new \StructType\GetValidEffectiveDates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEffectiveDateRange operation/method
 */
if ($get->GetEffectiveDateRange(new \StructType\GetEffectiveDateRange()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetState operation/method
 */
if ($get->GetState(new \StructType\GetState()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAgentInformation operation/method
 */
if ($get->GetAgentInformation(new \StructType\GetAgentInformation()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetListBill operation/method
 */
if ($get->GetListBill(new \StructType\GetListBill()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSTMTerms operation/method
 */
if ($get->GetSTMTerms(new \StructType\GetSTMTerms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Rate ServiceType
 */
$rate = new \ServiceType\Rate($options);
/**
 * Sample call for RatePlans operation/method
 */
if ($rate->RatePlans(new \StructType\RatePlans()) !== false) {
    print_r($rate->getResult());
} else {
    print_r($rate->getLastError());
}
/**
 * Sample call for RateCart operation/method
 */
if ($rate->RateCart(new \StructType\RateCart()) !== false) {
    print_r($rate->getResult());
} else {
    print_r($rate->getLastError());
}
/**
 * Sample call for RateSinglePlan operation/method
 */
if ($rate->RateSinglePlan(new \StructType\RateSinglePlan()) !== false) {
    print_r($rate->getResult());
} else {
    print_r($rate->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
/**
 * Sample call for ValidateAddress operation/method
 */
if ($validate->ValidateAddress(new \StructType\ValidateAddress()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
