<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateAddressRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateAddressRequest
 * @subpackage Structs
 */
class ValidateAddressRequest extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The Credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $Credentials;
    /**
     * Constructor method for ValidateAddressRequest
     * @uses ValidateAddressRequest::setAddress()
     * @uses ValidateAddressRequest::setCredentials()
     * @param \StructType\Address $address
     * @param \StructType\Credentials $credentials
     */
    public function __construct(\StructType\Address $address = null, \StructType\Credentials $credentials = null)
    {
        $this
            ->setAddress($address)
            ->setCredentials($credentials);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $address
     * @return \StructType\ValidateAddressRequest
     */
    public function setAddress(\StructType\Address $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return isset($this->Credentials) ? $this->Credentials : null;
    }
    /**
     * Set Credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $credentials
     * @return \StructType\ValidateAddressRequest
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->Credentials);
        } else {
            $this->Credentials = $credentials;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidateAddressRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
