<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SingleRatedPlan StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SingleRatedPlan
 * @subpackage Structs
 */
class SingleRatedPlan extends AbstractStructBase
{
    /**
     * The ApplicationTypeId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ApplicationTypeId;
    /**
     * The BaseProductName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaseProductName;
    /**
     * The BenefitPackageID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BenefitPackageID;
    /**
     * The CPPN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CPPN;
    /**
     * The HasDentalDiscountCard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasDentalDiscountCard;
    /**
     * The InsuranceRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $InsuranceRate;
    /**
     * The IsDiscounted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsDiscounted;
    /**
     * The IssueType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IssueType;
    /**
     * The MemberRates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMemberRate
     */
    public $MemberRates;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The PlanType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PlanType;
    /**
     * The ProductCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductCode;
    /**
     * The ProductRateComponents
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProductRate
     */
    public $ProductRateComponents;
    /**
     * The ProductSubCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductSubCode;
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProductType;
    /**
     * The Valid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Valid;
    /**
     * Constructor method for SingleRatedPlan
     * @uses SingleRatedPlan::setApplicationTypeId()
     * @uses SingleRatedPlan::setBaseProductName()
     * @uses SingleRatedPlan::setBenefitPackageID()
     * @uses SingleRatedPlan::setCPPN()
     * @uses SingleRatedPlan::setHasDentalDiscountCard()
     * @uses SingleRatedPlan::setInsuranceRate()
     * @uses SingleRatedPlan::setIsDiscounted()
     * @uses SingleRatedPlan::setIssueType()
     * @uses SingleRatedPlan::setMemberRates()
     * @uses SingleRatedPlan::setName()
     * @uses SingleRatedPlan::setPlanType()
     * @uses SingleRatedPlan::setProductCode()
     * @uses SingleRatedPlan::setProductRateComponents()
     * @uses SingleRatedPlan::setProductSubCode()
     * @uses SingleRatedPlan::setProductType()
     * @uses SingleRatedPlan::setValid()
     * @param int $applicationTypeId
     * @param string $baseProductName
     * @param string $benefitPackageID
     * @param string $cPPN
     * @param bool $hasDentalDiscountCard
     * @param float $insuranceRate
     * @param bool $isDiscounted
     * @param int $issueType
     * @param \ArrayType\ArrayOfMemberRate $memberRates
     * @param string $name
     * @param int $planType
     * @param string $productCode
     * @param \ArrayType\ArrayOfProductRate $productRateComponents
     * @param string $productSubCode
     * @param int $productType
     * @param bool $valid
     */
    public function __construct($applicationTypeId = null, $baseProductName = null, $benefitPackageID = null, $cPPN = null, $hasDentalDiscountCard = null, $insuranceRate = null, $isDiscounted = null, $issueType = null, \ArrayType\ArrayOfMemberRate $memberRates = null, $name = null, $planType = null, $productCode = null, \ArrayType\ArrayOfProductRate $productRateComponents = null, $productSubCode = null, $productType = null, $valid = null)
    {
        $this
            ->setApplicationTypeId($applicationTypeId)
            ->setBaseProductName($baseProductName)
            ->setBenefitPackageID($benefitPackageID)
            ->setCPPN($cPPN)
            ->setHasDentalDiscountCard($hasDentalDiscountCard)
            ->setInsuranceRate($insuranceRate)
            ->setIsDiscounted($isDiscounted)
            ->setIssueType($issueType)
            ->setMemberRates($memberRates)
            ->setName($name)
            ->setPlanType($planType)
            ->setProductCode($productCode)
            ->setProductRateComponents($productRateComponents)
            ->setProductSubCode($productSubCode)
            ->setProductType($productType)
            ->setValid($valid);
    }
    /**
     * Get ApplicationTypeId value
     * @return int|null
     */
    public function getApplicationTypeId()
    {
        return $this->ApplicationTypeId;
    }
    /**
     * Set ApplicationTypeId value
     * @param int $applicationTypeId
     * @return \StructType\SingleRatedPlan
     */
    public function setApplicationTypeId($applicationTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($applicationTypeId) && !is_numeric($applicationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($applicationTypeId)), __LINE__);
        }
        $this->ApplicationTypeId = $applicationTypeId;
        return $this;
    }
    /**
     * Get BaseProductName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaseProductName()
    {
        return isset($this->BaseProductName) ? $this->BaseProductName : null;
    }
    /**
     * Set BaseProductName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baseProductName
     * @return \StructType\SingleRatedPlan
     */
    public function setBaseProductName($baseProductName = null)
    {
        // validation for constraint: string
        if (!is_null($baseProductName) && !is_string($baseProductName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baseProductName)), __LINE__);
        }
        if (is_null($baseProductName) || (is_array($baseProductName) && empty($baseProductName))) {
            unset($this->BaseProductName);
        } else {
            $this->BaseProductName = $baseProductName;
        }
        return $this;
    }
    /**
     * Get BenefitPackageID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitPackageID()
    {
        return isset($this->BenefitPackageID) ? $this->BenefitPackageID : null;
    }
    /**
     * Set BenefitPackageID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $benefitPackageID
     * @return \StructType\SingleRatedPlan
     */
    public function setBenefitPackageID($benefitPackageID = null)
    {
        // validation for constraint: string
        if (!is_null($benefitPackageID) && !is_string($benefitPackageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($benefitPackageID)), __LINE__);
        }
        if (is_null($benefitPackageID) || (is_array($benefitPackageID) && empty($benefitPackageID))) {
            unset($this->BenefitPackageID);
        } else {
            $this->BenefitPackageID = $benefitPackageID;
        }
        return $this;
    }
    /**
     * Get CPPN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCPPN()
    {
        return isset($this->CPPN) ? $this->CPPN : null;
    }
    /**
     * Set CPPN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cPPN
     * @return \StructType\SingleRatedPlan
     */
    public function setCPPN($cPPN = null)
    {
        // validation for constraint: string
        if (!is_null($cPPN) && !is_string($cPPN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cPPN)), __LINE__);
        }
        if (is_null($cPPN) || (is_array($cPPN) && empty($cPPN))) {
            unset($this->CPPN);
        } else {
            $this->CPPN = $cPPN;
        }
        return $this;
    }
    /**
     * Get HasDentalDiscountCard value
     * @return bool|null
     */
    public function getHasDentalDiscountCard()
    {
        return $this->HasDentalDiscountCard;
    }
    /**
     * Set HasDentalDiscountCard value
     * @param bool $hasDentalDiscountCard
     * @return \StructType\SingleRatedPlan
     */
    public function setHasDentalDiscountCard($hasDentalDiscountCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasDentalDiscountCard) && !is_bool($hasDentalDiscountCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasDentalDiscountCard)), __LINE__);
        }
        $this->HasDentalDiscountCard = $hasDentalDiscountCard;
        return $this;
    }
    /**
     * Get InsuranceRate value
     * @return float|null
     */
    public function getInsuranceRate()
    {
        return $this->InsuranceRate;
    }
    /**
     * Set InsuranceRate value
     * @param float $insuranceRate
     * @return \StructType\SingleRatedPlan
     */
    public function setInsuranceRate($insuranceRate = null)
    {
        $this->InsuranceRate = $insuranceRate;
        return $this;
    }
    /**
     * Get IsDiscounted value
     * @return bool|null
     */
    public function getIsDiscounted()
    {
        return $this->IsDiscounted;
    }
    /**
     * Set IsDiscounted value
     * @param bool $isDiscounted
     * @return \StructType\SingleRatedPlan
     */
    public function setIsDiscounted($isDiscounted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDiscounted) && !is_bool($isDiscounted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDiscounted)), __LINE__);
        }
        $this->IsDiscounted = $isDiscounted;
        return $this;
    }
    /**
     * Get IssueType value
     * @return int|null
     */
    public function getIssueType()
    {
        return $this->IssueType;
    }
    /**
     * Set IssueType value
     * @param int $issueType
     * @return \StructType\SingleRatedPlan
     */
    public function setIssueType($issueType = null)
    {
        // validation for constraint: int
        if (!is_null($issueType) && !is_numeric($issueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($issueType)), __LINE__);
        }
        $this->IssueType = $issueType;
        return $this;
    }
    /**
     * Get MemberRates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMemberRate|null
     */
    public function getMemberRates()
    {
        return isset($this->MemberRates) ? $this->MemberRates : null;
    }
    /**
     * Set MemberRates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMemberRate $memberRates
     * @return \StructType\SingleRatedPlan
     */
    public function setMemberRates(\ArrayType\ArrayOfMemberRate $memberRates = null)
    {
        if (is_null($memberRates) || (is_array($memberRates) && empty($memberRates))) {
            unset($this->MemberRates);
        } else {
            $this->MemberRates = $memberRates;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\SingleRatedPlan
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PlanType value
     * @return int|null
     */
    public function getPlanType()
    {
        return $this->PlanType;
    }
    /**
     * Set PlanType value
     * @param int $planType
     * @return \StructType\SingleRatedPlan
     */
    public function setPlanType($planType = null)
    {
        // validation for constraint: int
        if (!is_null($planType) && !is_numeric($planType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($planType)), __LINE__);
        }
        $this->PlanType = $planType;
        return $this;
    }
    /**
     * Get ProductCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductCode()
    {
        return isset($this->ProductCode) ? $this->ProductCode : null;
    }
    /**
     * Set ProductCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productCode
     * @return \StructType\SingleRatedPlan
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCode)), __LINE__);
        }
        if (is_null($productCode) || (is_array($productCode) && empty($productCode))) {
            unset($this->ProductCode);
        } else {
            $this->ProductCode = $productCode;
        }
        return $this;
    }
    /**
     * Get ProductRateComponents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProductRate|null
     */
    public function getProductRateComponents()
    {
        return isset($this->ProductRateComponents) ? $this->ProductRateComponents : null;
    }
    /**
     * Set ProductRateComponents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProductRate $productRateComponents
     * @return \StructType\SingleRatedPlan
     */
    public function setProductRateComponents(\ArrayType\ArrayOfProductRate $productRateComponents = null)
    {
        if (is_null($productRateComponents) || (is_array($productRateComponents) && empty($productRateComponents))) {
            unset($this->ProductRateComponents);
        } else {
            $this->ProductRateComponents = $productRateComponents;
        }
        return $this;
    }
    /**
     * Get ProductSubCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductSubCode()
    {
        return isset($this->ProductSubCode) ? $this->ProductSubCode : null;
    }
    /**
     * Set ProductSubCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productSubCode
     * @return \StructType\SingleRatedPlan
     */
    public function setProductSubCode($productSubCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSubCode) && !is_string($productSubCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productSubCode)), __LINE__);
        }
        if (is_null($productSubCode) || (is_array($productSubCode) && empty($productSubCode))) {
            unset($this->ProductSubCode);
        } else {
            $this->ProductSubCode = $productSubCode;
        }
        return $this;
    }
    /**
     * Get ProductType value
     * @return int|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param int $productType
     * @return \StructType\SingleRatedPlan
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: int
        if (!is_null($productType) && !is_numeric($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get Valid value
     * @return bool|null
     */
    public function getValid()
    {
        return $this->Valid;
    }
    /**
     * Set Valid value
     * @param bool $valid
     * @return \StructType\SingleRatedPlan
     */
    public function setValid($valid = null)
    {
        // validation for constraint: boolean
        if (!is_null($valid) && !is_bool($valid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($valid)), __LINE__);
        }
        $this->Valid = $valid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SingleRatedPlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
