<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatedPlan StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RatedPlan
 * @subpackage Structs
 */
class RatedPlan extends AbstractStructBase
{
    /**
     * The AdditionalCoverages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdditionalCoverage
     */
    public $AdditionalCoverages;
    /**
     * The ApplicationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationType;
    /**
     * The BaseProducts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $BaseProducts;
    /**
     * The Benefits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBenefit
     */
    public $Benefits;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The EnrollerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnrollerId;
    /**
     * The HasDentalDiscountCard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasDentalDiscountCard;
    /**
     * The InsuranceRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $InsuranceRate;
    /**
     * The IsAMERider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAMERider;
    /**
     * The IsDiscounted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsDiscounted;
    /**
     * The IssueType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IssueType;
    /**
     * The MemberRates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMemberRate
     */
    public $MemberRates;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NumberOfDays
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfDays;
    /**
     * The PathToBrochure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PathToBrochure;
    /**
     * The PaymentFrequency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentFrequency;
    /**
     * The PlanKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PlanKey;
    /**
     * The PlanType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PlanType;
    /**
     * The ProductCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductCode;
    /**
     * The ProductSubCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductSubCode;
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProductType;
    /**
     * The ProviderLink
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderLink;
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Rate;
    /**
     * The Riders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRider
     */
    public $Riders;
    /**
     * The TotalRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalRate;
    /**
     * The WhomCovered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WhomCovered;
    /**
     * Constructor method for RatedPlan
     * @uses RatedPlan::setAdditionalCoverages()
     * @uses RatedPlan::setApplicationType()
     * @uses RatedPlan::setBaseProducts()
     * @uses RatedPlan::setBenefits()
     * @uses RatedPlan::setEffectiveDate()
     * @uses RatedPlan::setEnrollerId()
     * @uses RatedPlan::setHasDentalDiscountCard()
     * @uses RatedPlan::setInsuranceRate()
     * @uses RatedPlan::setIsAMERider()
     * @uses RatedPlan::setIsDiscounted()
     * @uses RatedPlan::setIssueType()
     * @uses RatedPlan::setMemberRates()
     * @uses RatedPlan::setName()
     * @uses RatedPlan::setNumberOfDays()
     * @uses RatedPlan::setPathToBrochure()
     * @uses RatedPlan::setPaymentFrequency()
     * @uses RatedPlan::setPlanKey()
     * @uses RatedPlan::setPlanType()
     * @uses RatedPlan::setProductCode()
     * @uses RatedPlan::setProductSubCode()
     * @uses RatedPlan::setProductType()
     * @uses RatedPlan::setProviderLink()
     * @uses RatedPlan::setRate()
     * @uses RatedPlan::setRiders()
     * @uses RatedPlan::setTotalRate()
     * @uses RatedPlan::setWhomCovered()
     * @param \ArrayType\ArrayOfAdditionalCoverage $additionalCoverages
     * @param string $applicationType
     * @param \ArrayType\ArrayOfstring $baseProducts
     * @param \ArrayType\ArrayOfBenefit $benefits
     * @param string $effectiveDate
     * @param string $enrollerId
     * @param bool $hasDentalDiscountCard
     * @param float $insuranceRate
     * @param bool $isAMERider
     * @param bool $isDiscounted
     * @param int $issueType
     * @param \ArrayType\ArrayOfMemberRate $memberRates
     * @param string $name
     * @param int $numberOfDays
     * @param string $pathToBrochure
     * @param int $paymentFrequency
     * @param string $planKey
     * @param int $planType
     * @param string $productCode
     * @param string $productSubCode
     * @param string $productType
     * @param string $providerLink
     * @param float $rate
     * @param \ArrayType\ArrayOfRider $riders
     * @param float $totalRate
     * @param string $whomCovered
     */
    public function __construct(\ArrayType\ArrayOfAdditionalCoverage $additionalCoverages = null, $applicationType = null, \ArrayType\ArrayOfstring $baseProducts = null, \ArrayType\ArrayOfBenefit $benefits = null, $effectiveDate = null, $enrollerId = null, $hasDentalDiscountCard = null, $insuranceRate = null, $isAMERider = null, $isDiscounted = null, $issueType = null, \ArrayType\ArrayOfMemberRate $memberRates = null, $name = null, $numberOfDays = null, $pathToBrochure = null, $paymentFrequency = null, $planKey = null, $planType = null, $productCode = null, $productSubCode = null, $productType = null, $providerLink = null, $rate = null, \ArrayType\ArrayOfRider $riders = null, $totalRate = null, $whomCovered = null)
    {
        $this
            ->setAdditionalCoverages($additionalCoverages)
            ->setApplicationType($applicationType)
            ->setBaseProducts($baseProducts)
            ->setBenefits($benefits)
            ->setEffectiveDate($effectiveDate)
            ->setEnrollerId($enrollerId)
            ->setHasDentalDiscountCard($hasDentalDiscountCard)
            ->setInsuranceRate($insuranceRate)
            ->setIsAMERider($isAMERider)
            ->setIsDiscounted($isDiscounted)
            ->setIssueType($issueType)
            ->setMemberRates($memberRates)
            ->setName($name)
            ->setNumberOfDays($numberOfDays)
            ->setPathToBrochure($pathToBrochure)
            ->setPaymentFrequency($paymentFrequency)
            ->setPlanKey($planKey)
            ->setPlanType($planType)
            ->setProductCode($productCode)
            ->setProductSubCode($productSubCode)
            ->setProductType($productType)
            ->setProviderLink($providerLink)
            ->setRate($rate)
            ->setRiders($riders)
            ->setTotalRate($totalRate)
            ->setWhomCovered($whomCovered);
    }
    /**
     * Get AdditionalCoverages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdditionalCoverage|null
     */
    public function getAdditionalCoverages()
    {
        return isset($this->AdditionalCoverages) ? $this->AdditionalCoverages : null;
    }
    /**
     * Set AdditionalCoverages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdditionalCoverage $additionalCoverages
     * @return \StructType\RatedPlan
     */
    public function setAdditionalCoverages(\ArrayType\ArrayOfAdditionalCoverage $additionalCoverages = null)
    {
        if (is_null($additionalCoverages) || (is_array($additionalCoverages) && empty($additionalCoverages))) {
            unset($this->AdditionalCoverages);
        } else {
            $this->AdditionalCoverages = $additionalCoverages;
        }
        return $this;
    }
    /**
     * Get ApplicationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationType()
    {
        return isset($this->ApplicationType) ? $this->ApplicationType : null;
    }
    /**
     * Set ApplicationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationType
     * @return \StructType\RatedPlan
     */
    public function setApplicationType($applicationType = null)
    {
        // validation for constraint: string
        if (!is_null($applicationType) && !is_string($applicationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationType)), __LINE__);
        }
        if (is_null($applicationType) || (is_array($applicationType) && empty($applicationType))) {
            unset($this->ApplicationType);
        } else {
            $this->ApplicationType = $applicationType;
        }
        return $this;
    }
    /**
     * Get BaseProducts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getBaseProducts()
    {
        return isset($this->BaseProducts) ? $this->BaseProducts : null;
    }
    /**
     * Set BaseProducts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $baseProducts
     * @return \StructType\RatedPlan
     */
    public function setBaseProducts(\ArrayType\ArrayOfstring $baseProducts = null)
    {
        if (is_null($baseProducts) || (is_array($baseProducts) && empty($baseProducts))) {
            unset($this->BaseProducts);
        } else {
            $this->BaseProducts = $baseProducts;
        }
        return $this;
    }
    /**
     * Get Benefits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBenefit|null
     */
    public function getBenefits()
    {
        return isset($this->Benefits) ? $this->Benefits : null;
    }
    /**
     * Set Benefits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBenefit $benefits
     * @return \StructType\RatedPlan
     */
    public function setBenefits(\ArrayType\ArrayOfBenefit $benefits = null)
    {
        if (is_null($benefits) || (is_array($benefits) && empty($benefits))) {
            unset($this->Benefits);
        } else {
            $this->Benefits = $benefits;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\RatedPlan
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get EnrollerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrollerId()
    {
        return isset($this->EnrollerId) ? $this->EnrollerId : null;
    }
    /**
     * Set EnrollerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enrollerId
     * @return \StructType\RatedPlan
     */
    public function setEnrollerId($enrollerId = null)
    {
        // validation for constraint: string
        if (!is_null($enrollerId) && !is_string($enrollerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enrollerId)), __LINE__);
        }
        if (is_null($enrollerId) || (is_array($enrollerId) && empty($enrollerId))) {
            unset($this->EnrollerId);
        } else {
            $this->EnrollerId = $enrollerId;
        }
        return $this;
    }
    /**
     * Get HasDentalDiscountCard value
     * @return bool|null
     */
    public function getHasDentalDiscountCard()
    {
        return $this->HasDentalDiscountCard;
    }
    /**
     * Set HasDentalDiscountCard value
     * @param bool $hasDentalDiscountCard
     * @return \StructType\RatedPlan
     */
    public function setHasDentalDiscountCard($hasDentalDiscountCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasDentalDiscountCard) && !is_bool($hasDentalDiscountCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasDentalDiscountCard)), __LINE__);
        }
        $this->HasDentalDiscountCard = $hasDentalDiscountCard;
        return $this;
    }
    /**
     * Get InsuranceRate value
     * @return float|null
     */
    public function getInsuranceRate()
    {
        return $this->InsuranceRate;
    }
    /**
     * Set InsuranceRate value
     * @param float $insuranceRate
     * @return \StructType\RatedPlan
     */
    public function setInsuranceRate($insuranceRate = null)
    {
        $this->InsuranceRate = $insuranceRate;
        return $this;
    }
    /**
     * Get IsAMERider value
     * @return bool|null
     */
    public function getIsAMERider()
    {
        return $this->IsAMERider;
    }
    /**
     * Set IsAMERider value
     * @param bool $isAMERider
     * @return \StructType\RatedPlan
     */
    public function setIsAMERider($isAMERider = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAMERider) && !is_bool($isAMERider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAMERider)), __LINE__);
        }
        $this->IsAMERider = $isAMERider;
        return $this;
    }
    /**
     * Get IsDiscounted value
     * @return bool|null
     */
    public function getIsDiscounted()
    {
        return $this->IsDiscounted;
    }
    /**
     * Set IsDiscounted value
     * @param bool $isDiscounted
     * @return \StructType\RatedPlan
     */
    public function setIsDiscounted($isDiscounted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDiscounted) && !is_bool($isDiscounted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDiscounted)), __LINE__);
        }
        $this->IsDiscounted = $isDiscounted;
        return $this;
    }
    /**
     * Get IssueType value
     * @return int|null
     */
    public function getIssueType()
    {
        return $this->IssueType;
    }
    /**
     * Set IssueType value
     * @param int $issueType
     * @return \StructType\RatedPlan
     */
    public function setIssueType($issueType = null)
    {
        // validation for constraint: int
        if (!is_null($issueType) && !is_numeric($issueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($issueType)), __LINE__);
        }
        $this->IssueType = $issueType;
        return $this;
    }
    /**
     * Get MemberRates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMemberRate|null
     */
    public function getMemberRates()
    {
        return isset($this->MemberRates) ? $this->MemberRates : null;
    }
    /**
     * Set MemberRates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMemberRate $memberRates
     * @return \StructType\RatedPlan
     */
    public function setMemberRates(\ArrayType\ArrayOfMemberRate $memberRates = null)
    {
        if (is_null($memberRates) || (is_array($memberRates) && empty($memberRates))) {
            unset($this->MemberRates);
        } else {
            $this->MemberRates = $memberRates;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\RatedPlan
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumberOfDays value
     * @return int|null
     */
    public function getNumberOfDays()
    {
        return $this->NumberOfDays;
    }
    /**
     * Set NumberOfDays value
     * @param int $numberOfDays
     * @return \StructType\RatedPlan
     */
    public function setNumberOfDays($numberOfDays = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDays) && !is_numeric($numberOfDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfDays)), __LINE__);
        }
        $this->NumberOfDays = $numberOfDays;
        return $this;
    }
    /**
     * Get PathToBrochure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPathToBrochure()
    {
        return isset($this->PathToBrochure) ? $this->PathToBrochure : null;
    }
    /**
     * Set PathToBrochure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pathToBrochure
     * @return \StructType\RatedPlan
     */
    public function setPathToBrochure($pathToBrochure = null)
    {
        // validation for constraint: string
        if (!is_null($pathToBrochure) && !is_string($pathToBrochure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pathToBrochure)), __LINE__);
        }
        if (is_null($pathToBrochure) || (is_array($pathToBrochure) && empty($pathToBrochure))) {
            unset($this->PathToBrochure);
        } else {
            $this->PathToBrochure = $pathToBrochure;
        }
        return $this;
    }
    /**
     * Get PaymentFrequency value
     * @return int|null
     */
    public function getPaymentFrequency()
    {
        return $this->PaymentFrequency;
    }
    /**
     * Set PaymentFrequency value
     * @param int $paymentFrequency
     * @return \StructType\RatedPlan
     */
    public function setPaymentFrequency($paymentFrequency = null)
    {
        // validation for constraint: int
        if (!is_null($paymentFrequency) && !is_numeric($paymentFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentFrequency)), __LINE__);
        }
        $this->PaymentFrequency = $paymentFrequency;
        return $this;
    }
    /**
     * Get PlanKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlanKey()
    {
        return isset($this->PlanKey) ? $this->PlanKey : null;
    }
    /**
     * Set PlanKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $planKey
     * @return \StructType\RatedPlan
     */
    public function setPlanKey($planKey = null)
    {
        // validation for constraint: string
        if (!is_null($planKey) && !is_string($planKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($planKey)), __LINE__);
        }
        if (is_null($planKey) || (is_array($planKey) && empty($planKey))) {
            unset($this->PlanKey);
        } else {
            $this->PlanKey = $planKey;
        }
        return $this;
    }
    /**
     * Get PlanType value
     * @return int|null
     */
    public function getPlanType()
    {
        return $this->PlanType;
    }
    /**
     * Set PlanType value
     * @param int $planType
     * @return \StructType\RatedPlan
     */
    public function setPlanType($planType = null)
    {
        // validation for constraint: int
        if (!is_null($planType) && !is_numeric($planType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($planType)), __LINE__);
        }
        $this->PlanType = $planType;
        return $this;
    }
    /**
     * Get ProductCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductCode()
    {
        return isset($this->ProductCode) ? $this->ProductCode : null;
    }
    /**
     * Set ProductCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productCode
     * @return \StructType\RatedPlan
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCode)), __LINE__);
        }
        if (is_null($productCode) || (is_array($productCode) && empty($productCode))) {
            unset($this->ProductCode);
        } else {
            $this->ProductCode = $productCode;
        }
        return $this;
    }
    /**
     * Get ProductSubCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductSubCode()
    {
        return isset($this->ProductSubCode) ? $this->ProductSubCode : null;
    }
    /**
     * Set ProductSubCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productSubCode
     * @return \StructType\RatedPlan
     */
    public function setProductSubCode($productSubCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSubCode) && !is_string($productSubCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productSubCode)), __LINE__);
        }
        if (is_null($productSubCode) || (is_array($productSubCode) && empty($productSubCode))) {
            unset($this->ProductSubCode);
        } else {
            $this->ProductSubCode = $productSubCode;
        }
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\ProductTypeId::valueIsValid()
     * @uses \EnumType\ProductTypeId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\RatedPlan
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductTypeId::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $productType, implode(', ', \EnumType\ProductTypeId::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get ProviderLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderLink()
    {
        return isset($this->ProviderLink) ? $this->ProviderLink : null;
    }
    /**
     * Set ProviderLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerLink
     * @return \StructType\RatedPlan
     */
    public function setProviderLink($providerLink = null)
    {
        // validation for constraint: string
        if (!is_null($providerLink) && !is_string($providerLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerLink)), __LINE__);
        }
        if (is_null($providerLink) || (is_array($providerLink) && empty($providerLink))) {
            unset($this->ProviderLink);
        } else {
            $this->ProviderLink = $providerLink;
        }
        return $this;
    }
    /**
     * Get Rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\RatedPlan
     */
    public function setRate($rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get Riders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRider|null
     */
    public function getRiders()
    {
        return isset($this->Riders) ? $this->Riders : null;
    }
    /**
     * Set Riders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRider $riders
     * @return \StructType\RatedPlan
     */
    public function setRiders(\ArrayType\ArrayOfRider $riders = null)
    {
        if (is_null($riders) || (is_array($riders) && empty($riders))) {
            unset($this->Riders);
        } else {
            $this->Riders = $riders;
        }
        return $this;
    }
    /**
     * Get TotalRate value
     * @return float|null
     */
    public function getTotalRate()
    {
        return $this->TotalRate;
    }
    /**
     * Set TotalRate value
     * @param float $totalRate
     * @return \StructType\RatedPlan
     */
    public function setTotalRate($totalRate = null)
    {
        $this->TotalRate = $totalRate;
        return $this;
    }
    /**
     * Get WhomCovered value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhomCovered()
    {
        return isset($this->WhomCovered) ? $this->WhomCovered : null;
    }
    /**
     * Set WhomCovered value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $whomCovered
     * @return \StructType\RatedPlan
     */
    public function setWhomCovered($whomCovered = null)
    {
        // validation for constraint: string
        if (!is_null($whomCovered) && !is_string($whomCovered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($whomCovered)), __LINE__);
        }
        if (is_null($whomCovered) || (is_array($whomCovered) && empty($whomCovered))) {
            unset($this->WhomCovered);
        } else {
            $this->WhomCovered = $whomCovered;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatedPlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
