<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateSinglePlanResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RateSinglePlanResponse
 * @subpackage Structs
 */
class RateSinglePlanResponse extends AbstractStructBase
{
    /**
     * The RatedPlan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SingleRatedPlan
     */
    public $RatedPlan;
    /**
     * The ValidationErrorInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ErrorInformation
     */
    public $ValidationErrorInformation;
    /**
     * The RateSinglePlanResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RateSinglePlanResponse
     */
    public $RateSinglePlanResult;
    /**
     * Constructor method for RateSinglePlanResponse
     * @uses RateSinglePlanResponse::setRatedPlan()
     * @uses RateSinglePlanResponse::setValidationErrorInformation()
     * @uses RateSinglePlanResponse::setRateSinglePlanResult()
     * @param \StructType\SingleRatedPlan $ratedPlan
     * @param \StructType\ErrorInformation $validationErrorInformation
     * @param \StructType\RateSinglePlanResponse $rateSinglePlanResult
     */
    public function __construct(\StructType\SingleRatedPlan $ratedPlan = null, \StructType\ErrorInformation $validationErrorInformation = null, \StructType\RateSinglePlanResponse $rateSinglePlanResult = null)
    {
        $this
            ->setRatedPlan($ratedPlan)
            ->setValidationErrorInformation($validationErrorInformation)
            ->setRateSinglePlanResult($rateSinglePlanResult);
    }
    /**
     * Get RatedPlan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SingleRatedPlan|null
     */
    public function getRatedPlan()
    {
        return isset($this->RatedPlan) ? $this->RatedPlan : null;
    }
    /**
     * Set RatedPlan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SingleRatedPlan $ratedPlan
     * @return \StructType\RateSinglePlanResponse
     */
    public function setRatedPlan(\StructType\SingleRatedPlan $ratedPlan = null)
    {
        if (is_null($ratedPlan) || (is_array($ratedPlan) && empty($ratedPlan))) {
            unset($this->RatedPlan);
        } else {
            $this->RatedPlan = $ratedPlan;
        }
        return $this;
    }
    /**
     * Get ValidationErrorInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ErrorInformation|null
     */
    public function getValidationErrorInformation()
    {
        return isset($this->ValidationErrorInformation) ? $this->ValidationErrorInformation : null;
    }
    /**
     * Set ValidationErrorInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ErrorInformation $validationErrorInformation
     * @return \StructType\RateSinglePlanResponse
     */
    public function setValidationErrorInformation(\StructType\ErrorInformation $validationErrorInformation = null)
    {
        if (is_null($validationErrorInformation) || (is_array($validationErrorInformation) && empty($validationErrorInformation))) {
            unset($this->ValidationErrorInformation);
        } else {
            $this->ValidationErrorInformation = $validationErrorInformation;
        }
        return $this;
    }
    /**
     * Get RateSinglePlanResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RateSinglePlanResponse|null
     */
    public function getRateSinglePlanResult()
    {
        return isset($this->RateSinglePlanResult) ? $this->RateSinglePlanResult : null;
    }
    /**
     * Set RateSinglePlanResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RateSinglePlanResponse $rateSinglePlanResult
     * @return \StructType\RateSinglePlanResponse
     */
    public function setRateSinglePlanResult(\StructType\RateSinglePlanResponse $rateSinglePlanResult = null)
    {
        if (is_null($rateSinglePlanResult) || (is_array($rateSinglePlanResult) && empty($rateSinglePlanResult))) {
            unset($this->RateSinglePlanResult);
        } else {
            $this->RateSinglePlanResult = $rateSinglePlanResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateSinglePlanResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
