<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlansResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RatePlansResponse
 * @subpackage Structs
 */
class RatePlansResponse extends AbstractStructBase
{
    /**
     * The RatedPlans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRatedPlan
     */
    public $RatedPlans;
    /**
     * The ValidationErrorInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ErrorInformation
     */
    public $ValidationErrorInformation;
    /**
     * The RatePlansResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RatePlansResponse
     */
    public $RatePlansResult;
    /**
     * Constructor method for RatePlansResponse
     * @uses RatePlansResponse::setRatedPlans()
     * @uses RatePlansResponse::setValidationErrorInformation()
     * @uses RatePlansResponse::setRatePlansResult()
     * @param \ArrayType\ArrayOfRatedPlan $ratedPlans
     * @param \StructType\ErrorInformation $validationErrorInformation
     * @param \StructType\RatePlansResponse $ratePlansResult
     */
    public function __construct(\ArrayType\ArrayOfRatedPlan $ratedPlans = null, \StructType\ErrorInformation $validationErrorInformation = null, \StructType\RatePlansResponse $ratePlansResult = null)
    {
        $this
            ->setRatedPlans($ratedPlans)
            ->setValidationErrorInformation($validationErrorInformation)
            ->setRatePlansResult($ratePlansResult);
    }
    /**
     * Get RatedPlans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRatedPlan|null
     */
    public function getRatedPlans()
    {
        return isset($this->RatedPlans) ? $this->RatedPlans : null;
    }
    /**
     * Set RatedPlans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRatedPlan $ratedPlans
     * @return \StructType\RatePlansResponse
     */
    public function setRatedPlans(\ArrayType\ArrayOfRatedPlan $ratedPlans = null)
    {
        if (is_null($ratedPlans) || (is_array($ratedPlans) && empty($ratedPlans))) {
            unset($this->RatedPlans);
        } else {
            $this->RatedPlans = $ratedPlans;
        }
        return $this;
    }
    /**
     * Get ValidationErrorInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ErrorInformation|null
     */
    public function getValidationErrorInformation()
    {
        return isset($this->ValidationErrorInformation) ? $this->ValidationErrorInformation : null;
    }
    /**
     * Set ValidationErrorInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ErrorInformation $validationErrorInformation
     * @return \StructType\RatePlansResponse
     */
    public function setValidationErrorInformation(\StructType\ErrorInformation $validationErrorInformation = null)
    {
        if (is_null($validationErrorInformation) || (is_array($validationErrorInformation) && empty($validationErrorInformation))) {
            unset($this->ValidationErrorInformation);
        } else {
            $this->ValidationErrorInformation = $validationErrorInformation;
        }
        return $this;
    }
    /**
     * Get RatePlansResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RatePlansResponse|null
     */
    public function getRatePlansResult()
    {
        return isset($this->RatePlansResult) ? $this->RatePlansResult : null;
    }
    /**
     * Set RatePlansResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RatePlansResponse $ratePlansResult
     * @return \StructType\RatePlansResponse
     */
    public function setRatePlansResult(\StructType\RatePlansResponse $ratePlansResult = null)
    {
        if (is_null($ratePlansResult) || (is_array($ratePlansResult) && empty($ratePlansResult))) {
            unset($this->RatePlansResult);
        } else {
            $this->RatePlansResult = $ratePlansResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlansResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
