<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanEffectiveDates StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PlanEffectiveDates
 * @subpackage Structs
 */
class PlanEffectiveDates extends AbstractStructBase
{
    /**
     * The DailyEffectiveDates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DailyEffectiveDates;
    /**
     * The FirstAvailableEffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstAvailableEffectiveDate;
    /**
     * The LastAvailableEffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LastAvailableEffectiveDate;
    /**
     * The PlanType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PlanType;
    /**
     * The ValidEffectiveDates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfdateTime
     */
    public $ValidEffectiveDates;
    /**
     * Constructor method for PlanEffectiveDates
     * @uses PlanEffectiveDates::setDailyEffectiveDates()
     * @uses PlanEffectiveDates::setFirstAvailableEffectiveDate()
     * @uses PlanEffectiveDates::setLastAvailableEffectiveDate()
     * @uses PlanEffectiveDates::setPlanType()
     * @uses PlanEffectiveDates::setValidEffectiveDates()
     * @param bool $dailyEffectiveDates
     * @param string $firstAvailableEffectiveDate
     * @param string $lastAvailableEffectiveDate
     * @param int $planType
     * @param \ArrayType\ArrayOfdateTime $validEffectiveDates
     */
    public function __construct($dailyEffectiveDates = null, $firstAvailableEffectiveDate = null, $lastAvailableEffectiveDate = null, $planType = null, \ArrayType\ArrayOfdateTime $validEffectiveDates = null)
    {
        $this
            ->setDailyEffectiveDates($dailyEffectiveDates)
            ->setFirstAvailableEffectiveDate($firstAvailableEffectiveDate)
            ->setLastAvailableEffectiveDate($lastAvailableEffectiveDate)
            ->setPlanType($planType)
            ->setValidEffectiveDates($validEffectiveDates);
    }
    /**
     * Get DailyEffectiveDates value
     * @return bool|null
     */
    public function getDailyEffectiveDates()
    {
        return $this->DailyEffectiveDates;
    }
    /**
     * Set DailyEffectiveDates value
     * @param bool $dailyEffectiveDates
     * @return \StructType\PlanEffectiveDates
     */
    public function setDailyEffectiveDates($dailyEffectiveDates = null)
    {
        // validation for constraint: boolean
        if (!is_null($dailyEffectiveDates) && !is_bool($dailyEffectiveDates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dailyEffectiveDates)), __LINE__);
        }
        $this->DailyEffectiveDates = $dailyEffectiveDates;
        return $this;
    }
    /**
     * Get FirstAvailableEffectiveDate value
     * @return string|null
     */
    public function getFirstAvailableEffectiveDate()
    {
        return $this->FirstAvailableEffectiveDate;
    }
    /**
     * Set FirstAvailableEffectiveDate value
     * @param string $firstAvailableEffectiveDate
     * @return \StructType\PlanEffectiveDates
     */
    public function setFirstAvailableEffectiveDate($firstAvailableEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstAvailableEffectiveDate) && !is_string($firstAvailableEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstAvailableEffectiveDate)), __LINE__);
        }
        $this->FirstAvailableEffectiveDate = $firstAvailableEffectiveDate;
        return $this;
    }
    /**
     * Get LastAvailableEffectiveDate value
     * @return string|null
     */
    public function getLastAvailableEffectiveDate()
    {
        return $this->LastAvailableEffectiveDate;
    }
    /**
     * Set LastAvailableEffectiveDate value
     * @param string $lastAvailableEffectiveDate
     * @return \StructType\PlanEffectiveDates
     */
    public function setLastAvailableEffectiveDate($lastAvailableEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastAvailableEffectiveDate) && !is_string($lastAvailableEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastAvailableEffectiveDate)), __LINE__);
        }
        $this->LastAvailableEffectiveDate = $lastAvailableEffectiveDate;
        return $this;
    }
    /**
     * Get PlanType value
     * @return int|null
     */
    public function getPlanType()
    {
        return $this->PlanType;
    }
    /**
     * Set PlanType value
     * @param int $planType
     * @return \StructType\PlanEffectiveDates
     */
    public function setPlanType($planType = null)
    {
        // validation for constraint: int
        if (!is_null($planType) && !is_numeric($planType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($planType)), __LINE__);
        }
        $this->PlanType = $planType;
        return $this;
    }
    /**
     * Get ValidEffectiveDates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfdateTime|null
     */
    public function getValidEffectiveDates()
    {
        return isset($this->ValidEffectiveDates) ? $this->ValidEffectiveDates : null;
    }
    /**
     * Set ValidEffectiveDates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfdateTime $validEffectiveDates
     * @return \StructType\PlanEffectiveDates
     */
    public function setValidEffectiveDates(\ArrayType\ArrayOfdateTime $validEffectiveDates = null)
    {
        if (is_null($validEffectiveDates) || (is_array($validEffectiveDates) && empty($validEffectiveDates))) {
            unset($this->ValidEffectiveDates);
        } else {
            $this->ValidEffectiveDates = $validEffectiveDates;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlanEffectiveDates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
