<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetValidEffectiveDatesRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetValidEffectiveDatesRequest
 * @subpackage Structs
 */
class GetValidEffectiveDatesRequest extends AbstractStructBase
{
    /**
     * The BrokerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrokerId;
    /**
     * The Credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $Credentials;
    /**
     * The PlanTypeId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PlanTypeId;
    /**
     * The RequestedEffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequestedEffectiveDate;
    /**
     * Constructor method for GetValidEffectiveDatesRequest
     * @uses GetValidEffectiveDatesRequest::setBrokerId()
     * @uses GetValidEffectiveDatesRequest::setCredentials()
     * @uses GetValidEffectiveDatesRequest::setPlanTypeId()
     * @uses GetValidEffectiveDatesRequest::setRequestedEffectiveDate()
     * @param string $brokerId
     * @param \StructType\Credentials $credentials
     * @param int $planTypeId
     * @param string $requestedEffectiveDate
     */
    public function __construct($brokerId = null, \StructType\Credentials $credentials = null, $planTypeId = null, $requestedEffectiveDate = null)
    {
        $this
            ->setBrokerId($brokerId)
            ->setCredentials($credentials)
            ->setPlanTypeId($planTypeId)
            ->setRequestedEffectiveDate($requestedEffectiveDate);
    }
    /**
     * Get BrokerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrokerId()
    {
        return isset($this->BrokerId) ? $this->BrokerId : null;
    }
    /**
     * Set BrokerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brokerId
     * @return \StructType\GetValidEffectiveDatesRequest
     */
    public function setBrokerId($brokerId = null)
    {
        // validation for constraint: string
        if (!is_null($brokerId) && !is_string($brokerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brokerId)), __LINE__);
        }
        if (is_null($brokerId) || (is_array($brokerId) && empty($brokerId))) {
            unset($this->BrokerId);
        } else {
            $this->BrokerId = $brokerId;
        }
        return $this;
    }
    /**
     * Get Credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return isset($this->Credentials) ? $this->Credentials : null;
    }
    /**
     * Set Credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $credentials
     * @return \StructType\GetValidEffectiveDatesRequest
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->Credentials);
        } else {
            $this->Credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get PlanTypeId value
     * @return int|null
     */
    public function getPlanTypeId()
    {
        return $this->PlanTypeId;
    }
    /**
     * Set PlanTypeId value
     * @param int $planTypeId
     * @return \StructType\GetValidEffectiveDatesRequest
     */
    public function setPlanTypeId($planTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($planTypeId) && !is_numeric($planTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($planTypeId)), __LINE__);
        }
        $this->PlanTypeId = $planTypeId;
        return $this;
    }
    /**
     * Get RequestedEffectiveDate value
     * @return string|null
     */
    public function getRequestedEffectiveDate()
    {
        return $this->RequestedEffectiveDate;
    }
    /**
     * Set RequestedEffectiveDate value
     * @param string $requestedEffectiveDate
     * @return \StructType\GetValidEffectiveDatesRequest
     */
    public function setRequestedEffectiveDate($requestedEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedEffectiveDate) && !is_string($requestedEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestedEffectiveDate)), __LINE__);
        }
        $this->RequestedEffectiveDate = $requestedEffectiveDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetValidEffectiveDatesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
