<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTermsRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTermsRequest
 * @subpackage Structs
 */
class GetTermsRequest extends AbstractStructBase
{
    /**
     * The BrokerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrokerId;
    /**
     * The Credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $Credentials;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The IssueType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IssueType;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for GetTermsRequest
     * @uses GetTermsRequest::setBrokerId()
     * @uses GetTermsRequest::setCredentials()
     * @uses GetTermsRequest::setEffectiveDate()
     * @uses GetTermsRequest::setIssueType()
     * @uses GetTermsRequest::setState()
     * @uses GetTermsRequest::setZipCode()
     * @param string $brokerId
     * @param \StructType\Credentials $credentials
     * @param string $effectiveDate
     * @param int $issueType
     * @param string $state
     * @param string $zipCode
     */
    public function __construct($brokerId = null, \StructType\Credentials $credentials = null, $effectiveDate = null, $issueType = null, $state = null, $zipCode = null)
    {
        $this
            ->setBrokerId($brokerId)
            ->setCredentials($credentials)
            ->setEffectiveDate($effectiveDate)
            ->setIssueType($issueType)
            ->setState($state)
            ->setZipCode($zipCode);
    }
    /**
     * Get BrokerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrokerId()
    {
        return isset($this->BrokerId) ? $this->BrokerId : null;
    }
    /**
     * Set BrokerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brokerId
     * @return \StructType\GetTermsRequest
     */
    public function setBrokerId($brokerId = null)
    {
        // validation for constraint: string
        if (!is_null($brokerId) && !is_string($brokerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brokerId)), __LINE__);
        }
        if (is_null($brokerId) || (is_array($brokerId) && empty($brokerId))) {
            unset($this->BrokerId);
        } else {
            $this->BrokerId = $brokerId;
        }
        return $this;
    }
    /**
     * Get Credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return isset($this->Credentials) ? $this->Credentials : null;
    }
    /**
     * Set Credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $credentials
     * @return \StructType\GetTermsRequest
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->Credentials);
        } else {
            $this->Credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\GetTermsRequest
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get IssueType value
     * @return int|null
     */
    public function getIssueType()
    {
        return $this->IssueType;
    }
    /**
     * Set IssueType value
     * @param int $issueType
     * @return \StructType\GetTermsRequest
     */
    public function setIssueType($issueType = null)
    {
        // validation for constraint: int
        if (!is_null($issueType) && !is_numeric($issueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($issueType)), __LINE__);
        }
        $this->IssueType = $issueType;
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \StructType\GetTermsRequest
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \StructType\GetTermsRequest
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetTermsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
